/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.Collections;
import org.apache.flink.streaming.api.operators.source.CollectingDataOutput;
import org.apache.flink.streaming.runtime.io.RecordAttributesCombiner;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributesBuilder;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RecordAttributesCombinerTest {
    RecordAttributesCombinerTest() {
    }

    @Test
    void testCombineRecordAttributes() throws Exception {
        RecordAttributesCombiner combiner = new RecordAttributesCombiner(3);
        CollectingDataOutput collectingDataOutput = new CollectingDataOutput();
        RecordAttributes backlogRecordAttribute = new RecordAttributesBuilder(Collections.emptyList()).setBacklog(true).build();
        RecordAttributes nonBacklogRecordAttribute = new RecordAttributesBuilder(Collections.emptyList()).setBacklog(false).build();
        combiner.inputRecordAttributes(backlogRecordAttribute, 0, collectingDataOutput);
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 0, collectingDataOutput);
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 0, collectingDataOutput);
        combiner.inputRecordAttributes(backlogRecordAttribute, 1, collectingDataOutput);
        combiner.inputRecordAttributes(backlogRecordAttribute, 2, collectingDataOutput);
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 1, collectingDataOutput);
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 2, collectingDataOutput);
        combiner.inputRecordAttributes(backlogRecordAttribute, 1, collectingDataOutput);
        Assertions.assertThat(collectingDataOutput.getEvents()).containsExactly(new Object[]{backlogRecordAttribute, nonBacklogRecordAttribute, backlogRecordAttribute});
    }

    @Test
    void testCombinerOnlyOutputNonBacklogWhenAllInputChannelAreNonBacklog() throws Exception {
        RecordAttributesCombiner combiner = new RecordAttributesCombiner(2);
        CollectingDataOutput collectingDataOutput = new CollectingDataOutput();
        RecordAttributes backlogRecordAttribute = new RecordAttributesBuilder(Collections.emptyList()).setBacklog(true).build();
        RecordAttributes nonBacklogRecordAttribute = new RecordAttributesBuilder(Collections.emptyList()).setBacklog(false).build();
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 0, collectingDataOutput);
        Assertions.assertThat(collectingDataOutput.getEvents()).isEmpty();
        combiner.inputRecordAttributes(backlogRecordAttribute, 0, collectingDataOutput);
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 1, collectingDataOutput);
        Assertions.assertThat(collectingDataOutput.getEvents()).containsExactly(new Object[]{backlogRecordAttribute});
        combiner.inputRecordAttributes(nonBacklogRecordAttribute, 0, collectingDataOutput);
        Assertions.assertThat(collectingDataOutput.getEvents()).containsExactly(new Object[]{backlogRecordAttribute, nonBacklogRecordAttribute});
    }
}

