/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.storage.FileSystemCheckpointStorage;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.CheckpointConfig;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CheckpointConfigFromConfigurationTest {
    private static Stream<TestSpec<?>> specs() {
        return Stream.of(TestSpec.testValue(CheckpointingMode.AT_LEAST_ONCE).whenSetFromFile("execution.checkpointing.mode", "AT_LEAST_ONCE").viaSetter(CheckpointConfig::setCheckpointingMode).getterVia(CheckpointConfig::getCheckpointingMode).nonDefaultValue(CheckpointingMode.AT_LEAST_ONCE), TestSpec.testValue(org.apache.flink.core.execution.CheckpointingMode.AT_LEAST_ONCE).whenSetFromFile("execution.checkpointing.mode", "AT_LEAST_ONCE").viaSetter(CheckpointConfig::setCheckpointingConsistencyMode).getterVia(CheckpointConfig::getCheckpointingConsistencyMode).nonDefaultValue(org.apache.flink.core.execution.CheckpointingMode.AT_LEAST_ONCE), TestSpec.testValue(org.apache.flink.core.execution.CheckpointingMode.AT_LEAST_ONCE).whenSetFromFile("execution.checkpointing.mode", "AT_LEAST_ONCE").viaSetter((config, v) -> config.setCheckpointingMode(CheckpointingMode.valueOf((String)v.name()))).getterVia(CheckpointConfig::getCheckpointingConsistencyMode).nonDefaultValue(org.apache.flink.core.execution.CheckpointingMode.AT_LEAST_ONCE), TestSpec.testValue(CheckpointingMode.AT_LEAST_ONCE).whenSetFromFile("execution.checkpointing.mode", "AT_LEAST_ONCE").viaSetter((config, v) -> config.setCheckpointingConsistencyMode(org.apache.flink.core.execution.CheckpointingMode.valueOf((String)v.name()))).getterVia(CheckpointConfig::getCheckpointingMode).nonDefaultValue(CheckpointingMode.AT_LEAST_ONCE), TestSpec.testValue(10000L).whenSetFromFile("execution.checkpointing.interval", "10 s").viaSetter(CheckpointConfig::setCheckpointInterval).getterVia(CheckpointConfig::getCheckpointInterval).nonDefaultValue(100L), TestSpec.testValue(12000L).whenSetFromFile("execution.checkpointing.timeout", "12 s").viaSetter(CheckpointConfig::setCheckpointTimeout).getterVia(CheckpointConfig::getCheckpointTimeout).nonDefaultValue(100L), TestSpec.testValue(12).whenSetFromFile("execution.checkpointing.max-concurrent-checkpoints", "12").viaSetter(CheckpointConfig::setMaxConcurrentCheckpoints).getterVia(CheckpointConfig::getMaxConcurrentCheckpoints).nonDefaultValue(100), TestSpec.testValue(1000L).whenSetFromFile("execution.checkpointing.min-pause", "1 s").viaSetter(CheckpointConfig::setMinPauseBetweenCheckpoints).getterVia(CheckpointConfig::getMinPauseBetweenCheckpoints).nonDefaultValue(100L), TestSpec.testValue(CheckpointConfig.ExternalizedCheckpointCleanup.RETAIN_ON_CANCELLATION).whenSetFromFile("execution.checkpointing.externalized-checkpoint-retention", "RETAIN_ON_CANCELLATION").viaSetter(CheckpointConfig::setExternalizedCheckpointCleanup).getterVia(CheckpointConfig::getExternalizedCheckpointCleanup).nonDefaultValue(CheckpointConfig.ExternalizedCheckpointCleanup.DELETE_ON_CANCELLATION), TestSpec.testValue(12).whenSetFromFile("execution.checkpointing.tolerable-failed-checkpoints", "12").viaSetter(CheckpointConfig::setTolerableCheckpointFailureNumber).getterVia(CheckpointConfig::getTolerableCheckpointFailureNumber).nonDefaultValue(100), TestSpec.testValue(true).whenSetFromFile("execution.checkpointing.unaligned.enabled", "true").viaSetter(CheckpointConfig::enableUnalignedCheckpoints).getterVia(CheckpointConfig::isUnalignedCheckpointsEnabled).nonDefaultValue(true), TestSpec.testValue(new FileSystemCheckpointStorage("file:///path/to/checkpoint/dir")).whenSetFromFile(CheckpointingOptions.CHECKPOINTS_DIRECTORY.key(), "file:///path/to/checkpoint/dir").viaSetter(CheckpointConfig::setCheckpointStorage).getterVia(CheckpointConfig::getCheckpointStorage).nonDefaultValue((CheckpointStorage)new FileSystemCheckpointStorage("file:///path/to/checkpoint/dir")).customMatcher((actualValue, expectedValue) -> {
            AbstractObjectAssert cfr_ignored_0 = (AbstractObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)actualValue).hasSameClassAs(expectedValue)).asInstanceOf(InstanceOfAssertFactories.type(FileSystemCheckpointStorage.class))).extracting(FileSystemCheckpointStorage::getCheckpointPath).isEqualTo((Object)((FileSystemCheckpointStorage)expectedValue).getCheckpointPath());
        }));
    }

    @ParameterizedTest
    @MethodSource(value={"specs"})
    public void testLoadingFromConfiguration(TestSpec<?> spec) {
        CheckpointConfig configFromSetters = new CheckpointConfig();
        CheckpointConfig configFromFile = new CheckpointConfig();
        Configuration configuration = new Configuration();
        configuration.setString(((TestSpec)spec).key, ((TestSpec)spec).value);
        configFromFile.configure((ReadableConfig)configuration);
        spec.setValue(configFromSetters);
        spec.assertEqual(configFromFile, configFromSetters);
    }

    @ParameterizedTest
    @MethodSource(value={"specs"})
    public void testNotOverridingIfNotSet(TestSpec<?> spec) {
        CheckpointConfig config = new CheckpointConfig();
        spec.setNonDefaultValue(config);
        Configuration configuration = new Configuration();
        config.configure((ReadableConfig)configuration);
        spec.assertEqualNonDefault(config);
    }

    private static class TestSpec<T> {
        private String key;
        private String value;
        private final T objectValue;
        private T nonDefaultValue;
        private BiConsumer<CheckpointConfig, T> setter;
        private Function<CheckpointConfig, T> getter;
        private BiConsumer<T, T> customAssertion = (actualValue, expectedValue) -> {
            ObjectAssert cfr_ignored_0 = (ObjectAssert)Assertions.assertThat((Object)actualValue).isEqualTo(expectedValue);
        };

        private TestSpec(T value) {
            this.objectValue = value;
        }

        public static <T> TestSpec<T> testValue(T value) {
            return new TestSpec<T>(value);
        }

        public TestSpec<T> whenSetFromFile(String key, String value) {
            this.key = key;
            this.value = value;
            return this;
        }

        public TestSpec<T> viaSetter(BiConsumer<CheckpointConfig, T> setter) {
            this.setter = setter;
            return this;
        }

        public TestSpec<T> getterVia(Function<CheckpointConfig, T> getter) {
            this.getter = getter;
            return this;
        }

        public TestSpec<T> nonDefaultValue(T nonDefaultValue) {
            this.nonDefaultValue = nonDefaultValue;
            return this;
        }

        public TestSpec<T> customMatcher(BiConsumer<T, T> customAssertion) {
            this.customAssertion = customAssertion;
            return this;
        }

        public void setValue(CheckpointConfig config) {
            this.setter.accept(config, (CheckpointConfig)this.objectValue);
        }

        public void setNonDefaultValue(CheckpointConfig config) {
            this.setter.accept(config, (CheckpointConfig)this.nonDefaultValue);
        }

        public void assertEqual(CheckpointConfig configFromFile, CheckpointConfig configFromSetters) {
            this.customAssertion.accept(this.getter.apply(configFromFile), this.getter.apply(configFromSetters));
        }

        public void assertEqualNonDefault(CheckpointConfig configFromFile) {
            this.customAssertion.accept(this.getter.apply(configFromFile), this.nonDefaultValue);
        }

        public String toString() {
            return "key='" + this.key + '\'';
        }
    }
}

