/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.streaming.api.connector.sink2.CommittableWithLineage;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class CommittableWithLinageAssert
extends AbstractAssert<CommittableWithLinageAssert, CommittableWithLineage<?>> {
    public CommittableWithLinageAssert(CommittableWithLineage<?> summary) {
        super(summary, CommittableWithLinageAssert.class);
    }

    public CommittableWithLinageAssert isEqualTo(CommittableWithLineage<?> committableWithLineage) {
        this.isNotNull();
        Assertions.assertThat((int)((CommittableWithLineage)this.actual).getSubtaskId()).isEqualTo(committableWithLineage.getSubtaskId());
        Assertions.assertThat((OptionalLong)((CommittableWithLineage)this.actual).getCheckpointId()).isEqualTo((Object)committableWithLineage.getCheckpointId());
        Assertions.assertThat((Object)((CommittableWithLineage)this.actual).getCommittable()).isEqualTo(committableWithLineage.getCommittable());
        return this;
    }

    public CommittableWithLinageAssert hasCommittable(Object committable) {
        this.isNotNull();
        Assertions.assertThat((Object)((CommittableWithLineage)this.actual).getCommittable()).isEqualTo(committable);
        return this;
    }

    public CommittableWithLinageAssert hasCheckpointId(@Nullable Long checkpointId) {
        this.isNotNull();
        if (checkpointId == null) {
            Assertions.assertThat((OptionalLong)((CommittableWithLineage)this.actual).getCheckpointId()).isEmpty();
        } else {
            Assertions.assertThat((OptionalLong)((CommittableWithLineage)this.actual).getCheckpointId()).hasValue(checkpointId.longValue());
        }
        return this;
    }

    public CommittableWithLinageAssert hasSubtaskId(int subtaskId) {
        this.isNotNull();
        Assertions.assertThat((int)((CommittableWithLineage)this.actual).getSubtaskId()).isEqualTo(subtaskId);
        return this;
    }
}

