/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.operators.sortpartition.KeyedSortPartitionOperator;
import org.apache.flink.streaming.api.transformations.OneInputTransformation;
import org.apache.flink.streaming.runtime.translators.AbstractOneInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.BatchExecutionUtils;

@Internal
public final class OneInputTransformationTranslator<IN, OUT>
extends AbstractOneInputTransformationTranslator<IN, OUT, OneInputTransformation<IN, OUT>> {
    @Override
    public Collection<Integer> translateForBatchInternal(OneInputTransformation<IN, OUT> transformation, TransformationTranslator.Context context) {
        Collection<Integer> ids = this.translateInternal(transformation, transformation.getOperatorFactory(), transformation.getInputType(), transformation.getStateKeySelector(), transformation.getStateKeyType(), context);
        this.maybeApplyBatchExecutionSettings(transformation, context);
        return ids;
    }

    @Override
    public Collection<Integer> translateForStreamingInternal(OneInputTransformation<IN, OUT> transformation, TransformationTranslator.Context context) {
        Collection<Integer> ids = this.translateInternal(transformation, transformation.getOperatorFactory(), transformation.getInputType(), transformation.getStateKeySelector(), transformation.getStateKeyType(), context);
        if (transformation.isOutputOnlyAfterEndOfStream()) {
            this.maybeApplyBatchExecutionSettings(transformation, context);
        }
        return ids;
    }

    private void maybeApplyBatchExecutionSettings(OneInputTransformation<IN, OUT> transformation, TransformationTranslator.Context context) {
        KeySelector<IN, ?> keySelector = transformation.getStateKeySelector();
        if (keySelector != null) {
            StreamOperatorFactory<OUT> operatorFactory = transformation.getOperatorFactory();
            if (operatorFactory instanceof SimpleOperatorFactory && operatorFactory.getStreamOperatorClass(Thread.currentThread().getContextClassLoader()) == KeyedSortPartitionOperator.class) {
                return;
            }
            BatchExecutionUtils.applyBatchExecutionSettings(transformation.getId(), context, StreamConfig.InputRequirement.SORTED);
        }
    }
}

