/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public abstract class AbstractMultipleInputTransformation<OUT>
extends PhysicalTransformation<OUT> {
    protected final List<Transformation<?>> inputs = new ArrayList();
    protected final StreamOperatorFactory<OUT> operatorFactory;

    public AbstractMultipleInputTransformation(String name, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outputType, int parallelism) {
        super(name, outputType, parallelism);
        this.operatorFactory = operatorFactory;
    }

    public AbstractMultipleInputTransformation(String name, StreamOperatorFactory<OUT> operatorFactory, TypeInformation<OUT> outputType, int parallelism, boolean parallelismConfigured) {
        super(name, outputType, parallelism, parallelismConfigured);
        this.operatorFactory = operatorFactory;
    }

    public List<Transformation<?>> getInputs() {
        return this.inputs;
    }

    public List<TypeInformation<?>> getInputTypes() {
        return this.inputs.stream().map(Transformation::getOutputType).collect(Collectors.toList());
    }

    public StreamOperatorFactory<OUT> getOperatorFactory() {
        return this.operatorFactory;
    }

    protected List<Transformation<?>> getTransitivePredecessorsInternal() {
        List<Transformation<?>> predecessors = this.getInputs().stream().flatMap(input -> input.getTransitivePredecessors().stream()).distinct().collect(Collectors.toList());
        predecessors.add(this);
        return predecessors;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        this.operatorFactory.setChainingStrategy(strategy);
    }

    public boolean isOutputOnlyAfterEndOfStream() {
        return this.operatorFactory.getOperatorAttributes().isOutputOnlyAfterEndOfStream();
    }
}

