/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.windowing.functions;

import java.util.Collections;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.IterationRuntimeContext;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.operators.translation.WrappingFunction;
import org.apache.flink.streaming.api.functions.windowing.ProcessAllWindowFunction;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalProcessAllWindowContext;
import org.apache.flink.streaming.runtime.operators.windowing.functions.InternalWindowFunction;
import org.apache.flink.util.Collector;

public final class InternalAggregateProcessAllWindowFunction<T, ACC, V, R, W extends Window>
extends WrappingFunction<ProcessAllWindowFunction<V, R, W>>
implements InternalWindowFunction<Iterable<T>, R, Byte, W> {
    private static final long serialVersionUID = 1L;
    private final AggregateFunction<T, ACC, V> aggFunction;
    private transient InternalProcessAllWindowContext<V, R, W> ctx;

    public InternalAggregateProcessAllWindowFunction(AggregateFunction<T, ACC, V> aggFunction, ProcessAllWindowFunction<V, R, W> windowFunction) {
        super(windowFunction);
        this.aggFunction = aggFunction;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        ProcessAllWindowFunction wrappedFunction = (ProcessAllWindowFunction)this.wrappedFunction;
        this.ctx = new InternalProcessAllWindowContext(wrappedFunction);
    }

    @Override
    public void process(Byte key, W window, InternalWindowFunction.InternalWindowContext context, Iterable<T> input, Collector<R> out) throws Exception {
        Object acc = this.aggFunction.createAccumulator();
        for (T val : input) {
            acc = this.aggFunction.add(val, acc);
        }
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ProcessAllWindowFunction wrappedFunction = (ProcessAllWindowFunction)this.wrappedFunction;
        wrappedFunction.process(this.ctx, Collections.singletonList(this.aggFunction.getResult(acc)), out);
    }

    @Override
    public void clear(W window, InternalWindowFunction.InternalWindowContext context) throws Exception {
        this.ctx.window = window;
        this.ctx.internalContext = context;
        ((ProcessAllWindowFunction)this.wrappedFunction).clear(this.ctx);
    }

    public RuntimeContext getRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }

    public IterationRuntimeContext getIterationRuntimeContext() {
        throw new RuntimeException("This should never be called.");
    }
}

