/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.connector.sink2;

import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.streaming.api.connector.sink2.CommittableMessage;
import org.apache.flink.util.Preconditions;

@Experimental
public class CommittableWithLineage<CommT>
implements CommittableMessage<CommT> {
    private final CommT committable;
    @Nullable
    private final Long checkpointId;
    private final int subtaskId;

    public CommittableWithLineage(CommT committable, @Nullable Long checkpointId, int subtaskId) {
        this.committable = Preconditions.checkNotNull(committable);
        this.checkpointId = checkpointId;
        this.subtaskId = subtaskId;
    }

    public CommT getCommittable() {
        return this.committable;
    }

    @Override
    public int getSubtaskId() {
        return this.subtaskId;
    }

    @Override
    public OptionalLong getCheckpointId() {
        return this.checkpointId == null ? OptionalLong.empty() : OptionalLong.of(this.checkpointId);
    }
}

