/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.util.MultiInputStreamOperatorTestHarness;

public class KeyedMultiInputStreamOperatorTestHarness<KEY, OUT>
extends MultiInputStreamOperatorTestHarness<OUT> {
    public KeyedMultiInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operator, TypeInformation<KEY> keyType) throws Exception {
        this(operator, 1, 1, 0);
        this.config.setStateKeySerializer(keyType.createSerializer(this.executionConfig));
        this.config.serializeAllConfigs();
    }

    public KeyedMultiInputStreamOperatorTestHarness(StreamOperatorFactory<OUT> operatorFactory, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        super(operatorFactory, maxParallelism, numSubtasks, subtaskIndex);
    }

    public void setKeySelector(int idx, KeySelector<?, KEY> keySelector) {
        ClosureCleaner.clean(keySelector, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)false);
        this.config.setStatePartitioner(idx, keySelector);
        this.config.serializeAllConfigs();
    }
}

