/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.co.KeyedBroadcastProcessFunction;
import org.apache.flink.streaming.api.transformations.AbstractBroadcastStateTransformation;

@Internal
public class KeyedBroadcastStateTransformation<KEY, IN1, IN2, OUT>
extends AbstractBroadcastStateTransformation<IN1, IN2, OUT> {
    private final KeyedBroadcastProcessFunction<KEY, IN1, IN2, OUT> userFunction;
    private final TypeInformation<KEY> stateKeyType;
    private final KeySelector<IN1, KEY> keySelector;

    public KeyedBroadcastStateTransformation(String name, Transformation<IN1> inputStream, Transformation<IN2> broadcastStream, KeyedBroadcastProcessFunction<KEY, IN1, IN2, OUT> userFunction, List<MapStateDescriptor<?, ?>> broadcastStateDescriptors, TypeInformation<KEY> keyType, KeySelector<IN1, KEY> keySelector, TypeInformation<OUT> outTypeInfo, int parallelism) {
        super(name, inputStream, broadcastStream, broadcastStateDescriptors, outTypeInfo, parallelism);
        this.userFunction = userFunction;
        this.stateKeyType = keyType;
        this.keySelector = keySelector;
        this.updateManagedMemoryStateBackendUseCase(true);
    }

    public KeyedBroadcastProcessFunction<KEY, IN1, IN2, OUT> getUserFunction() {
        return this.userFunction;
    }

    public TypeInformation<KEY> getStateKeyType() {
        return this.stateKeyType;
    }

    public KeySelector<IN1, KEY> getKeySelector() {
        return this.keySelector;
    }
}

