/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.restore;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.state.IncrementalLocalKeyedStateHandle;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.state.rocksdb.RocksDBIncrementalCheckpointUtils;
import org.apache.flink.state.rocksdb.restore.RestoredDBInstance;
import org.apache.flink.state.rocksdb.ttl.RocksDbTtlCompactFiltersManager;
import org.apache.flink.types.Either;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.ExportImportFilesMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributeStateHandlerHelper
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DistributeStateHandlerHelper.class);
    private final IncrementalLocalKeyedStateHandle stateHandle;
    private final RestoredDBInstance restoredDbInstance;
    private final int keyGroupPrefixBytes;
    private final KeyGroupRange keyGroupRange;
    private final String operatorIdentifier;
    private final int index;

    public DistributeStateHandlerHelper(IncrementalLocalKeyedStateHandle stateHandle, List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, DBOptions dbOptions, RocksDbTtlCompactFiltersManager ttlCompactFiltersManager, Long writeBufferManagerCapacity, int keyGroupPrefixBytes, KeyGroupRange keyGroupRange, String operatorIdentifier, int index) throws Exception {
        this.stateHandle = stateHandle;
        this.keyGroupPrefixBytes = keyGroupPrefixBytes;
        this.keyGroupRange = keyGroupRange;
        this.operatorIdentifier = operatorIdentifier;
        this.index = index;
        String logLineSuffix = this.createLogLineSuffix();
        LOG.debug("Opening temporary database : {}", (Object)logLineSuffix);
        this.restoredDbInstance = RestoredDBInstance.restoreTempDBInstanceFromLocalState(stateHandle, stateMetaInfoSnapshots, columnFamilyOptionsFactory, dbOptions, ttlCompactFiltersManager, writeBufferManagerCapacity);
    }

    public Either<KeyGroupRange, IncrementalLocalKeyedStateHandle> tryDistribute(Path exportCfBasePath, Map<RegisteredStateMetaInfoBase.Key, List<ExportImportFilesMetaData>> exportedColumnFamiliesOut) throws Exception {
        String logLineSuffix = this.createLogLineSuffix();
        List<ColumnFamilyHandle> tmpColumnFamilyHandles = this.restoredDbInstance.columnFamilyHandles;
        LOG.debug("Checking actual keys of sst files {}", (Object)logLineSuffix);
        RocksDBIncrementalCheckpointUtils.RangeCheckResult rangeCheckResult = RocksDBIncrementalCheckpointUtils.checkSstDataAgainstKeyGroupRange(this.restoredDbInstance.db, this.keyGroupPrefixBytes, this.stateHandle.getKeyGroupRange());
        LOG.info("{} {}", (Object)rangeCheckResult, (Object)logLineSuffix);
        if (rangeCheckResult.allInRange()) {
            LOG.debug("Start exporting {}", (Object)logLineSuffix);
            List<RegisteredStateMetaInfoBase> registeredStateMetaInfoBases = this.restoredDbInstance.stateMetaInfoSnapshots.stream().map(RegisteredStateMetaInfoBase::fromMetaInfoSnapshot).collect(Collectors.toList());
            RocksDBIncrementalCheckpointUtils.exportColumnFamilies(this.restoredDbInstance.db, tmpColumnFamilyHandles, registeredStateMetaInfoBases, exportCfBasePath, exportedColumnFamiliesOut);
            LOG.debug("Done exporting {}", (Object)logLineSuffix);
            return Either.Left((Object)this.stateHandle.getKeyGroupRange());
        }
        LOG.debug("Skipped export {}", (Object)logLineSuffix);
        return Either.Right((Object)this.stateHandle);
    }

    @Override
    public void close() throws Exception {
        this.restoredDbInstance.close();
    }

    private String createLogLineSuffix() {
        return " for state handle at index " + this.index + " with proclaimed key-group range " + this.stateHandle.getKeyGroupRange().prettyPrintInterval() + " for backend with range " + this.keyGroupRange.prettyPrintInterval() + " in operator " + this.operatorIdentifier + ".";
    }
}

