/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.iterator;

import javax.annotation.Nonnull;
import org.apache.flink.state.rocksdb.RocksIteratorWrapper;
import org.apache.flink.state.rocksdb.iterator.SingleStateIterator;
import org.apache.flink.util.IOUtils;

class RocksSingleStateIterator
implements SingleStateIterator {
    @Nonnull
    private final RocksIteratorWrapper iterator;
    private byte[] currentKey;
    private final int kvStateId;

    RocksSingleStateIterator(@Nonnull RocksIteratorWrapper iterator, int kvStateId) {
        this.iterator = iterator;
        this.currentKey = iterator.key();
        this.kvStateId = kvStateId;
    }

    @Override
    public void next() {
        this.iterator.next();
        if (this.iterator.isValid()) {
            this.currentKey = this.iterator.key();
        }
    }

    @Override
    public boolean isValid() {
        return this.iterator.isValid();
    }

    @Override
    public byte[] key() {
        return this.currentKey;
    }

    @Override
    public byte[] value() {
        return this.iterator.value();
    }

    @Override
    public int getKvStateId() {
        return this.kvStateId;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.iterator);
    }
}

