/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.runtime.state.CompositeKeySerializationUtils;
import org.apache.flink.state.rocksdb.RocksIteratorWrapper;
import org.apache.flink.state.rocksdb.iterator.AbstractRocksStateKeysIterator;
import org.apache.flink.util.FlinkRuntimeException;

public class RocksStateKeysAndNamespaceIterator<K, N>
extends AbstractRocksStateKeysIterator<K>
implements Iterator<Tuple2<K, N>> {
    @Nonnull
    private final TypeSerializer<N> namespaceSerializer;
    private Tuple2<K, N> nextKeyAndNamespace;
    private Tuple2<K, N> previousKeyAndNamespace;

    public RocksStateKeysAndNamespaceIterator(@Nonnull RocksIteratorWrapper iterator, @Nonnull String state, @Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer, int keyGroupPrefixBytes, boolean ambiguousKeyPossible) {
        super(iterator, state, keySerializer, keyGroupPrefixBytes, ambiguousKeyPossible);
        this.namespaceSerializer = namespaceSerializer;
        this.nextKeyAndNamespace = null;
        this.previousKeyAndNamespace = null;
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.nextKeyAndNamespace == null && this.iterator.isValid()) {
                Object currentNamespace;
                byte[] keyBytes = this.iterator.key();
                Object currentKey = this.deserializeKey(keyBytes, this.byteArrayDataInputView);
                Tuple2 currentKeyAndNamespace = Tuple2.of(currentKey, (Object)(currentNamespace = CompositeKeySerializationUtils.readNamespace(this.namespaceSerializer, (DataInputDeserializer)this.byteArrayDataInputView, (boolean)this.ambiguousKeyPossible)));
                if (!Objects.equals(this.previousKeyAndNamespace, currentKeyAndNamespace)) {
                    this.previousKeyAndNamespace = currentKeyAndNamespace;
                    this.nextKeyAndNamespace = currentKeyAndNamespace;
                }
                this.iterator.next();
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to access state [" + this.state + "]", (Throwable)e);
        }
        return this.nextKeyAndNamespace != null;
    }

    @Override
    public Tuple2<K, N> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Failed to access state [" + this.state + "]");
        }
        Tuple2<K, N> tmpKeyAndNamespace = this.nextKeyAndNamespace;
        this.nextKeyAndNamespace = null;
        return tmpKeyAndNamespace;
    }
}

