/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.state.rocksdb.EmbeddedRocksDBStateBackend;
import org.apache.flink.state.rocksdb.RocksDBOptions;
import org.apache.flink.util.Preconditions;

public class RocksDBPriorityQueueConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int UNDEFINED_ROCKSDB_PRIORITY_QUEUE_SET_CACHE_SIZE = -1;
    @Nullable
    private EmbeddedRocksDBStateBackend.PriorityQueueStateType priorityQueueStateType;
    private int rocksDBPriorityQueueSetCacheSize;

    public RocksDBPriorityQueueConfig() {
        this(null, -1);
    }

    public RocksDBPriorityQueueConfig(EmbeddedRocksDBStateBackend.PriorityQueueStateType priorityQueueStateType, int rocksDBPriorityQueueSetCacheSize) {
        this.priorityQueueStateType = priorityQueueStateType;
        this.rocksDBPriorityQueueSetCacheSize = rocksDBPriorityQueueSetCacheSize;
    }

    public EmbeddedRocksDBStateBackend.PriorityQueueStateType getPriorityQueueStateType() {
        return this.priorityQueueStateType == null ? (EmbeddedRocksDBStateBackend.PriorityQueueStateType)((Object)RocksDBOptions.TIMER_SERVICE_FACTORY.defaultValue()) : this.priorityQueueStateType;
    }

    public void setPriorityQueueStateType(EmbeddedRocksDBStateBackend.PriorityQueueStateType type) {
        this.priorityQueueStateType = (EmbeddedRocksDBStateBackend.PriorityQueueStateType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    public int getRocksDBPriorityQueueSetCacheSize() {
        return this.rocksDBPriorityQueueSetCacheSize == -1 ? (Integer)RocksDBOptions.ROCKSDB_TIMER_SERVICE_FACTORY_CACHE_SIZE.defaultValue() : this.rocksDBPriorityQueueSetCacheSize;
    }

    public static RocksDBPriorityQueueConfig fromOtherAndConfiguration(RocksDBPriorityQueueConfig other, ReadableConfig config) {
        EmbeddedRocksDBStateBackend.PriorityQueueStateType priorityQueueType = null == other.priorityQueueStateType ? (EmbeddedRocksDBStateBackend.PriorityQueueStateType)((Object)config.get(RocksDBOptions.TIMER_SERVICE_FACTORY)) : other.priorityQueueStateType;
        int cacheSize = other.rocksDBPriorityQueueSetCacheSize == -1 ? (Integer)config.get(RocksDBOptions.ROCKSDB_TIMER_SERVICE_FACTORY_CACHE_SIZE) : other.rocksDBPriorityQueueSetCacheSize;
        return new RocksDBPriorityQueueConfig(priorityQueueType, cacheSize);
    }

    public static RocksDBPriorityQueueConfig buildWithPriorityQueueType(EmbeddedRocksDBStateBackend.PriorityQueueStateType type) {
        return new RocksDBPriorityQueueConfig(type, (Integer)RocksDBOptions.ROCKSDB_TIMER_SERVICE_FACTORY_CACHE_SIZE.defaultValue());
    }
}

