/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.rocksdb.sstmerge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.shaded.guava32.com.google.common.primitives.UnsignedBytes;
import org.apache.flink.state.rocksdb.sstmerge.ColumnFamilyLookup;
import org.apache.flink.state.rocksdb.sstmerge.CompactionTask;
import org.apache.flink.state.rocksdb.sstmerge.RocksDBManualCompactionConfig;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.LiveFileMetaData;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CompactionTaskProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionTaskProducer.class);
    private static final Comparator<SstFileMetaData> SST_COMPARATOR = (o1, o2) -> {
        Comparator cmp = UnsignedBytes.lexicographicalComparator();
        int cfCmp = cmp.compare(o1.columnFamilyName(), o2.columnFamilyName());
        if (cfCmp != 0) {
            return cfCmp;
        }
        return cmp.compare(o1.smallestKey(), o2.smallestKey());
    };
    private final RocksDBManualCompactionConfig settings;
    private final ColumnFamilyLookup columnFamilyLookup;
    private final Supplier<List<SstFileMetaData>> metadataSupplier;

    CompactionTaskProducer(RocksDB db, RocksDBManualCompactionConfig settings, ColumnFamilyLookup columnFamilyLookup) {
        this(() -> SstFileMetaData.mapFrom(db.getLiveFilesMetaData()), settings, columnFamilyLookup);
    }

    CompactionTaskProducer(Supplier<List<SstFileMetaData>> metadataSupplier, RocksDBManualCompactionConfig settings, ColumnFamilyLookup columnFamilyLookup) {
        this.settings = settings;
        this.columnFamilyLookup = columnFamilyLookup;
        this.metadataSupplier = metadataSupplier;
    }

    public List<CompactionTask> produce() {
        List<SstFileMetaData> sstSortedByCfAndStartingKeys = this.metadataSupplier.get().stream().filter(l -> l.level() > 0).sorted(SST_COMPARATOR).collect(Collectors.toList());
        LOG.trace("Input files: {}", (Object)sstSortedByCfAndStartingKeys.size());
        List<CompactionTask> tasks = this.groupIntoTasks(sstSortedByCfAndStartingKeys);
        tasks.sort(Comparator.comparingInt(t -> t.files.size()).reversed());
        return tasks.subList(0, Math.min(tasks.size(), this.settings.maxManualCompactions));
    }

    private List<CompactionTask> groupIntoTasks(List<SstFileMetaData> files) {
        ArrayList<CompactionTask> tasks = new ArrayList<CompactionTask>();
        ArrayList<SstFileMetaData> group = new ArrayList<SstFileMetaData>();
        SstFileMetaData prevFile = null;
        long compactionOutputSize = 0L;
        for (SstFileMetaData file : files) {
            boolean newGroup;
            boolean compact = this.shouldCompact(file);
            boolean bl = newGroup = !compact || !this.sameGroup(file, prevFile, group, compactionOutputSize);
            if (newGroup) {
                this.createTask(group).ifPresent(tasks::add);
                group.clear();
                compactionOutputSize = 0L;
            }
            if (compact) {
                group.add(file);
                compactionOutputSize += file.size();
            }
            LOG.trace("Processed SST file: {}, level={}, cf: {}, being compacted={}, compact: {}, change group: {}, prev level={}", new Object[]{file.fileName(), file.level(), file.columnFamilyName(), file.beingCompacted(), compact, newGroup, prevFile == null ? -1 : prevFile.level()});
            prevFile = file;
        }
        this.createTask(group).ifPresent(tasks::add);
        return tasks;
    }

    private Optional<CompactionTask> createTask(List<SstFileMetaData> compaction) {
        if (compaction.size() < this.settings.minFilesToCompact) {
            return Optional.empty();
        }
        SstFileMetaData head = compaction.iterator().next();
        ColumnFamilyHandle cf = this.columnFamilyLookup.get(head.columnFamilyName());
        if (cf == null) {
            LOG.warn("Unknown column family: {}", (Object)head.columnFamilyName);
            return Optional.empty();
        }
        List<String> fileNames = compaction.stream().map(SstFileMetaData::fileName).collect(Collectors.toList());
        return Optional.of(new CompactionTask(head.level(), fileNames, cf));
    }

    private boolean sameGroup(SstFileMetaData file, SstFileMetaData prevFile, List<SstFileMetaData> group, long compactionOutputSize) {
        if (prevFile == null) {
            return true;
        }
        return file.level() == prevFile.level() && Arrays.equals(file.columnFamilyName(), prevFile.columnFamilyName()) && compactionOutputSize + file.size() <= this.settings.maxOutputFileSize.getBytes() && group.size() < this.settings.maxFilesToCompact;
    }

    private boolean shouldCompact(SstFileMetaData file) {
        return file.size() <= this.settings.maxFileSizeToCompact.getBytes() && !file.beingCompacted();
    }

    static class SstFileMetaData {
        private final byte[] columnFamilyName;
        private final String fileName;
        private final int level;
        private final long size;
        private final byte[] smallestKey;
        private final boolean beingCompacted;

        public SstFileMetaData(byte[] columnFamilyName, String fileName, int level, long size, byte[] smallestKey, boolean beingCompacted) {
            this.columnFamilyName = columnFamilyName;
            this.fileName = fileName;
            this.level = level;
            this.size = size;
            this.smallestKey = smallestKey;
            this.beingCompacted = beingCompacted;
        }

        public String fileName() {
            return this.fileName;
        }

        public byte[] columnFamilyName() {
            return this.columnFamilyName;
        }

        public int level() {
            return this.level;
        }

        public long size() {
            return this.size;
        }

        public byte[] smallestKey() {
            return this.smallestKey;
        }

        public boolean beingCompacted() {
            return this.beingCompacted;
        }

        static List<SstFileMetaData> mapFrom(List<LiveFileMetaData> list) {
            return list.stream().map(SstFileMetaData::fromLiveFileMetaData).collect(Collectors.toList());
        }

        static SstFileMetaData fromLiveFileMetaData(LiveFileMetaData fileMetaData) {
            return new SstFileMetaData(fileMetaData.columnFamilyName(), fileMetaData.fileName(), fileMetaData.level(), fileMetaData.size(), fileMetaData.smallestKey(), fileMetaData.beingCompacted());
        }
    }
}

