/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state.sstmerge;

import java.time.Duration;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;

public class RocksDBManualCompactionOptions {
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<Duration> MIN_INTERVAL = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.min-interval").durationType().defaultValue((Object)Duration.ofMinutes(0L)).withDescription("The minimum interval between manual compactions. Zero disables manual compactions");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<Integer> MAX_PARALLEL_COMPACTIONS = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.max-parallel-compactions").intType().defaultValue((Object)5).withDescription("The maximum number of manual compactions to start.Note that only one of them can run at a time as of v8.10.0; all the others will be waiting");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<MemorySize> MAX_FILE_SIZE_TO_COMPACT = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.max-file-size-to-compact").memoryType().defaultValue((Object)MemorySize.parse((String)"50k")).withDescription("The maximum size of individual input files");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<Integer> MIN_FILES_TO_COMPACT = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.min-files-to-compact").intType().defaultValue((Object)5).withDescription("The minimum number of input files to compact together in a single compaction run");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<Integer> MAX_FILES_TO_COMPACT = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.max-files-to-compact").intType().defaultValue((Object)30).withDescription("The maximum number of input files to compact together in a single compaction run");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<MemorySize> MAX_OUTPUT_FILE_SIZE = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.max-output-file-size").memoryType().defaultValue((Object)MemorySize.parse((String)"64Mb")).withDescription("The maximum output file size");
    @Documentation.Section(value={"expert_rocksdb"})
    public static final ConfigOption<Integer> MAX_AUTO_COMPACTIONS = ConfigOptions.key((String)"state.backend.rocksdb.manual-compaction.max-auto-compactions").intType().defaultValue((Object)30).withDescription("The maximum number of automatic compactions running for manual compaction to start.If the actual number is higher, manual compaction won't be started to avoid delaying automatic ones.");
}

