/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Closeable;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.flink.util.FlinkRuntimeException;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.RocksIteratorInterface;

public class RocksIteratorWrapper
implements RocksIteratorInterface,
Closeable {
    private RocksIterator iterator;

    public RocksIteratorWrapper(@Nonnull RocksIterator iterator) {
        this.iterator = iterator;
    }

    public boolean isValid() {
        boolean isValid = this.iterator.isValid();
        if (!isValid) {
            this.status();
        }
        return isValid;
    }

    public void seekToFirst() {
        this.iterator.seekToFirst();
    }

    public void seekToLast() {
        this.iterator.seekToLast();
    }

    public void seek(byte[] target) {
        this.iterator.seek(target);
    }

    public void seekForPrev(byte[] target) {
        this.iterator.seekForPrev(target);
    }

    public void seek(ByteBuffer target) {
        this.iterator.seek(target);
    }

    public void seekForPrev(ByteBuffer target) {
        this.iterator.seekForPrev(target);
    }

    public void next() {
        this.iterator.next();
    }

    public void prev() {
        this.iterator.prev();
    }

    public void status() {
        try {
            this.iterator.status();
        }
        catch (RocksDBException ex) {
            throw new FlinkRuntimeException("Internal exception found in RocksDB", (Throwable)ex);
        }
    }

    public void refresh() throws RocksDBException {
        this.iterator.refresh();
        this.status();
    }

    public byte[] key() {
        return this.iterator.key();
    }

    public byte[] value() {
        return this.iterator.value();
    }

    @Override
    public void close() {
        this.iterator.close();
    }
}

