/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.filemapping;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.asyncprocessing.ReferenceCounted;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.state.forst.fs.cache.FileBasedCache;
import org.apache.flink.state.forst.fs.filemapping.FileBackedMappingEntrySource;
import org.apache.flink.state.forst.fs.filemapping.FileOwnership;
import org.apache.flink.state.forst.fs.filemapping.HandleBackedMappingEntrySource;
import org.apache.flink.state.forst.fs.filemapping.MappingEntrySource;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingEntry
extends ReferenceCounted {
    private static final Logger LOG = LoggerFactory.getLogger(MappingEntry.class);
    MappingEntrySource source;
    FileOwnership fileOwnership;
    @Nullable
    final FileBasedCache cache;
    final boolean isDirectory;
    volatile boolean writing;
    @Nullable
    MappingEntry parentDir;

    public MappingEntry(int initReference, StreamStateHandle stateHandle, FileOwnership fileOwnership, boolean isDirectory) {
        this(initReference, new HandleBackedMappingEntrySource(stateHandle), fileOwnership, null, isDirectory, false);
    }

    public MappingEntry(int initReference, Path sourcePath, FileOwnership fileOwnership, boolean isDirectory) {
        this(initReference, new FileBackedMappingEntrySource(sourcePath), fileOwnership, null, isDirectory, false);
    }

    public MappingEntry(int initReference, MappingEntrySource source, FileOwnership fileOwnership, FileBasedCache cache, boolean isDirectory, boolean writing) {
        super(initReference);
        this.source = source;
        this.parentDir = null;
        this.fileOwnership = fileOwnership;
        this.cache = cache;
        this.isDirectory = isDirectory;
        this.writing = writing;
        if (!writing && cache != null && !isDirectory && source.cacheable()) {
            try {
                cache.registerInCache(source.getFilePath(), source.getSize());
            }
            catch (IOException e) {
                LOG.warn("Failed to register file {} in cache.", (Object)source, (Object)e);
            }
        }
    }

    public void setFileOwnership(FileOwnership ownership) {
        this.fileOwnership = ownership;
    }

    public void setSource(StreamStateHandle stateHandle) {
        if (this.source instanceof HandleBackedMappingEntrySource) {
            Preconditions.checkArgument((boolean)((HandleBackedMappingEntrySource)this.source).getStateHandle().equals(stateHandle), (String)"MappingSource is already back by a different StateHandle: %s, the new one is: %s", (Object[])new Object[]{this.source, stateHandle});
            return;
        }
        LOG.trace("Set source for file: {}, the source is now backed by: {}", (Object)this, (Object)stateHandle);
        this.source = new HandleBackedMappingEntrySource(stateHandle);
    }

    public MappingEntrySource getSource() {
        return this.source;
    }

    @Nullable
    public Path getSourcePath() {
        return this.source.getFilePath();
    }

    public FileOwnership getFileOwnership() {
        return this.fileOwnership;
    }

    public boolean isWriting() {
        return this.writing;
    }

    public void endWriting() {
        this.writing = false;
    }

    protected void referenceCountReachedZero(@Nullable Object o) {
        try {
            if (this.parentDir != null) {
                this.parentDir.release();
            }
            if (this.fileOwnership == FileOwnership.NOT_OWNED) {
                return;
            }
            this.source.delete(this.isDirectory);
            if (this.cache != null && !this.isDirectory && this.source.cacheable()) {
                this.cache.delete(this.source.getFilePath());
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to delete file {}.", (Object)this.source, (Object)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        return this.source.equals(((MappingEntry)((Object)o)).source);
    }

    public String toString() {
        return "MappingEntry{source=" + String.valueOf(this.source) + ", fileOwnership=" + String.valueOf((Object)this.fileOwnership) + ", isDirectory= " + this.isDirectory + "}";
    }
}

