/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.filemapping;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filemerging.SegmentFileStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.state.forst.fs.filemapping.MappingEntrySource;

public class HandleBackedMappingEntrySource
extends MappingEntrySource {
    @Nonnull
    private final StreamStateHandle stateHandle;

    HandleBackedMappingEntrySource(@Nonnull StreamStateHandle stateHandle) {
        this.stateHandle = stateHandle;
    }

    @Nonnull
    public StreamStateHandle getStateHandle() {
        return this.stateHandle;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandleBackedMappingEntrySource that = (HandleBackedMappingEntrySource)o;
        return this.stateHandle.equals(that.stateHandle);
    }

    public String toString() {
        return "HandleBackedSource{stateHandle=" + String.valueOf(this.stateHandle) + "}";
    }

    @Override
    public void delete(boolean recursive) throws IOException {
    }

    @Override
    @Nullable
    public Path getFilePath() {
        if (this.stateHandle instanceof FileStateHandle) {
            return ((FileStateHandle)this.stateHandle).getFilePath();
        }
        if (this.stateHandle instanceof SegmentFileStateHandle) {
            return ((SegmentFileStateHandle)this.stateHandle).getFilePath();
        }
        return null;
    }

    @Override
    public long getSize() throws IOException {
        return this.stateHandle.getStateSize();
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.stateHandle.openInputStream();
    }

    @Override
    public FSDataInputStream openInputStream(int bufferSize) throws IOException {
        return this.stateHandle.openInputStream();
    }

    @Override
    public boolean cacheable() {
        return this.stateHandle instanceof FileStateHandle;
    }

    @Override
    public StreamStateHandle toStateHandle() {
        return this.stateHandle;
    }
}

