/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs.filemapping;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.state.forst.fs.filemapping.MappingEntrySource;

public class FileBackedMappingEntrySource
extends MappingEntrySource {
    @Nonnull
    private final Path filePath;

    FileBackedMappingEntrySource(@Nonnull Path filePath) {
        this.filePath = filePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBackedMappingEntrySource that = (FileBackedMappingEntrySource)o;
        return this.filePath.equals((Object)that.filePath);
    }

    public String toString() {
        return "FileBackedSource{filePath=" + String.valueOf(this.filePath) + "}";
    }

    @Override
    public void delete(boolean recursive) throws IOException {
        LOG.trace("Delete the file backing a MappingEntry: {}", (Object)this);
        this.filePath.getFileSystem().delete(this.filePath, recursive);
    }

    @Override
    @Nonnull
    public Path getFilePath() {
        return this.filePath;
    }

    @Override
    public long getSize() throws IOException {
        return this.filePath.getFileSystem().getFileStatus(this.filePath).getLen();
    }

    @Override
    public FSDataInputStream openInputStream() throws IOException {
        return this.filePath.getFileSystem().open(this.filePath);
    }

    @Override
    public FSDataInputStream openInputStream(int bufferSize) throws IOException {
        return this.filePath.getFileSystem().open(this.filePath, bufferSize);
    }

    @Override
    public boolean cacheable() {
        return true;
    }

    @Override
    public StreamStateHandle toStateHandle() throws IOException {
        return new FileStateHandle(this.filePath, this.getSize());
    }
}

