/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.fs.ByteBufferReadableFSDataInputStream;
import org.apache.flink.state.forst.fs.ByteBufferWritableFSDataOutputStream;
import org.apache.flink.state.forst.fs.ForStFileStatus;
import org.apache.flink.state.forst.fs.ForStFileSystemUtils;
import org.apache.flink.state.forst.fs.ForStFlinkFileSystem;

public class StringifiedForStFileSystem {
    private ForStFlinkFileSystem fileSystem;

    public StringifiedForStFileSystem(ForStFlinkFileSystem fileSystem) {
        this.fileSystem = ForStFileSystemUtils.tryDecorate(fileSystem);
    }

    public static StringifiedForStFileSystem get(String uri) throws IOException {
        return new StringifiedForStFileSystem(ForStFlinkFileSystem.get(URI.create(uri)));
    }

    public boolean exists(String path) throws IOException {
        return this.fileSystem.exists(new Path(path));
    }

    public ForStFileStatus getFileStatus(String path) throws IOException {
        return new ForStFileStatus(this.fileSystem.getFileStatus(new Path(path)));
    }

    public ForStFileStatus[] listStatus(String path) throws IOException {
        return (ForStFileStatus[])Arrays.stream(this.fileSystem.listStatus(new Path(path))).map(ForStFileStatus::new).toArray(ForStFileStatus[]::new);
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        return this.fileSystem.delete(new Path(path), recursive);
    }

    public boolean mkdirs(String path) throws IOException {
        return this.fileSystem.mkdirs(new Path(path));
    }

    public boolean rename(String src, String dst) throws IOException {
        return this.fileSystem.rename(new Path(src), new Path(dst));
    }

    public ByteBufferReadableFSDataInputStream open(String path) throws IOException {
        return this.fileSystem.open(new Path(path));
    }

    public ByteBufferWritableFSDataOutputStream create(String path) throws IOException {
        return this.fileSystem.create(new Path(path));
    }

    public int link(String src, String dst) throws IOException {
        return this.fileSystem.link(new Path(src), new Path(dst));
    }
}

