/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.fs.ForStFileSystemTrackingCreatedDirDecorator;
import org.apache.flink.state.forst.fs.ForStFlinkFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForStFileSystemUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ForStFileSystemUtils.class);
    private static final String DUMMY_DIR_NAME = "_dummy_dir_";

    public static boolean isParentDir(@Nullable Path path, String dir) {
        if (path == null) {
            return false;
        }
        return ForStFileSystemUtils.isParentDir(path.toString(), dir);
    }

    public static boolean isParentDir(String path, String dir) {
        if (dir.isEmpty()) {
            return false;
        }
        if (dir.charAt(dir.length() - 1) == '/') {
            return path.startsWith(dir);
        }
        return path.startsWith(dir + "/");
    }

    public static ForStFlinkFileSystem tryDecorate(ForStFlinkFileSystem fileSystem) {
        try {
            return ForStFileSystemUtils.isIncompleteMkdirEnabled(fileSystem) ? new ForStFileSystemTrackingCreatedDirDecorator(fileSystem) : fileSystem;
        }
        catch (IOException e) {
            LOG.info("Cannot decorate ForStFlinkFileSystem", (Throwable)e);
            return fileSystem;
        }
    }

    private static boolean isIncompleteMkdirEnabled(ForStFlinkFileSystem fileSystem) throws IOException {
        Path dummyDir = new Path(fileSystem.getRemoteBase(), DUMMY_DIR_NAME + String.valueOf(UUID.randomUUID()));
        if (fileSystem.mkdirs(dummyDir)) {
            if (!fileSystem.exists(dummyDir)) {
                return true;
            }
            fileSystem.delete(new Path(DUMMY_DIR_NAME), true);
            return false;
        }
        LOG.info("Cannot to mkdir for _dummy_dir_, skip decoration of ForStFlinkFileSystem");
        return false;
    }
}

