/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.fs.ForStFlinkFileSystem;

public class ForStFileSystemTrackingCreatedDirDecorator
extends ForStFlinkFileSystem {
    private final Set<Path> createdDirPaths = new HashSet<Path>();

    ForStFileSystemTrackingCreatedDirDecorator(ForStFlinkFileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    public synchronized boolean mkdirs(Path path) throws IOException {
        boolean mkdirSucceed = super.mkdirs(path);
        if (!mkdirSucceed) {
            return false;
        }
        this.createdDirPaths.add(path);
        return true;
    }

    @Override
    public synchronized boolean exists(Path f) throws IOException {
        if (this.createdDirPaths.contains(f)) {
            return true;
        }
        return super.exists(f);
    }
}

