/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestHandler;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.runtime.state.SerializedCompositeKeyBuilder;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.runtime.state.v2.AbstractReducingState;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStDBSingleGetRequest;
import org.apache.flink.state.forst.ForStInnerTable;
import org.apache.flink.state.forst.ForStSerializerUtils;
import org.apache.flink.util.Preconditions;
import org.forstdb.ColumnFamilyHandle;

public class ForStReducingState<K, N, V>
extends AbstractReducingState<K, N, V>
implements ForStInnerTable<K, N, V> {
    private final ColumnFamilyHandle columnFamilyHandle;
    private final ThreadLocal<SerializedCompositeKeyBuilder<K>> serializedKeyBuilder;
    private final N defaultNamespace;
    private final ThreadLocal<TypeSerializer<N>> namespaceSerializer;
    private final ThreadLocal<DataOutputSerializer> valueSerializerView;
    private final ThreadLocal<DataInputDeserializer> valueDeserializerView;
    private final boolean enableKeyReuse;

    public ForStReducingState(StateRequestHandler stateRequestHandler, ColumnFamilyHandle columnFamily, ReduceFunction<V> reduceFunction, TypeSerializer<V> valueSerializer, Supplier<SerializedCompositeKeyBuilder<K>> serializedKeyBuilderInitializer, N defaultNamespace, Supplier<TypeSerializer<N>> namespaceSerializerInitializer, Supplier<DataOutputSerializer> valueSerializerViewInitializer, Supplier<DataInputDeserializer> valueDeserializerViewInitializer) {
        super(stateRequestHandler, reduceFunction, valueSerializer);
        this.columnFamilyHandle = columnFamily;
        this.serializedKeyBuilder = ThreadLocal.withInitial(serializedKeyBuilderInitializer);
        this.defaultNamespace = defaultNamespace;
        this.namespaceSerializer = ThreadLocal.withInitial(namespaceSerializerInitializer);
        this.valueSerializerView = ThreadLocal.withInitial(valueSerializerViewInitializer);
        this.valueDeserializerView = ThreadLocal.withInitial(valueDeserializerViewInitializer);
        this.enableKeyReuse = defaultNamespace instanceof VoidNamespace && namespaceSerializerInitializer.get() instanceof VoidNamespaceSerializer;
    }

    @Override
    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.columnFamilyHandle;
    }

    @Override
    public byte[] serializeKey(ContextKey<K, N> contextKey) throws IOException {
        return ForStSerializerUtils.serializeKeyAndNamespace(contextKey, this.serializedKeyBuilder.get(), this.defaultNamespace, this.namespaceSerializer.get(), this.enableKeyReuse);
    }

    @Override
    public byte[] serializeValue(V value) throws IOException {
        DataOutputSerializer outputView = this.valueSerializerView.get();
        outputView.clear();
        this.getValueSerializer().serialize(value, (DataOutputView)outputView);
        return outputView.getCopyOfBuffer();
    }

    @Override
    public V deserializeValue(byte[] valueBytes) throws IOException {
        DataInputDeserializer inputView = this.valueDeserializerView.get();
        inputView.setBuffer(valueBytes);
        return (V)this.getValueSerializer().deserialize((DataInputView)inputView);
    }

    @Override
    public ForStDBGetRequest<K, N, V, V> buildDBGetRequest(StateRequest<?, ?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.REDUCING_GET ? 1 : 0) != 0);
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace());
        return new ForStDBSingleGetRequest(contextKey, this, stateRequest.getFuture());
    }

    @Override
    public ForStDBPutRequest<K, N, V> buildDBPutRequest(StateRequest<?, ?, ?, ?> stateRequest) {
        Preconditions.checkArgument((stateRequest.getRequestType() == StateRequestType.REDUCING_ADD || stateRequest.getRequestType() == StateRequestType.CLEAR ? 1 : 0) != 0);
        ContextKey contextKey = new ContextKey(stateRequest.getRecordContext(), stateRequest.getNamespace());
        Object value = stateRequest.getRequestType() == StateRequestType.CLEAR ? null : stateRequest.getPayload();
        return ForStDBPutRequest.of(contextKey, value, this, (InternalAsyncFuture<Void>)stateRequest.getFuture());
    }
}

