/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStDBWriteBatchWrapper;
import org.apache.flink.state.forst.ForStMapState;
import org.forstdb.RocksDB;
import org.forstdb.RocksDBException;
import org.forstdb.RocksIterator;

public class ForStDBBunchPutRequest<K, N, UK, UV>
extends ForStDBPutRequest<K, N, Map<UK, UV>> {
    final ThreadLocal<TypeSerializer<UV>> userValueSerializer;
    final ThreadLocal<DataOutputSerializer> valueSerializerView;
    final ThreadLocal<DataInputDeserializer> valueDeserializerView;
    final int keyGroupPrefixBytes;

    public ForStDBBunchPutRequest(ContextKey<K, N> key, Map<UK, UV> value, ForStMapState<K, N, UK, UV> table, InternalAsyncFuture<Void> future) {
        super(key, value, false, table, future);
        this.userValueSerializer = table.userValueSerializer;
        this.valueSerializerView = table.valueSerializerView;
        this.valueDeserializerView = table.valueDeserializerView;
        this.keyGroupPrefixBytes = table.getKeyGroupPrefixBytes();
    }

    @Override
    public void process(ForStDBWriteBatchWrapper writeBatchWrapper, RocksDB db) throws IOException, RocksDBException {
        if (this.value == null) {
            byte[] prefix = this.buildSerializedKey(null);
            try (RocksIterator iter = db.newIterator(this.table.getColumnFamilyHandle());){
                byte[] rocksKey;
                iter.seek(prefix);
                while (iter.isValid() && ForStDBIterRequest.startWithKeyPrefix(prefix, rocksKey = iter.key(), this.keyGroupPrefixBytes)) {
                    writeBatchWrapper.remove(this.table.getColumnFamilyHandle(), rocksKey);
                    iter.next();
                }
            }
        } else {
            for (Map.Entry entry : ((Map)this.value).entrySet()) {
                byte[] key = this.buildSerializedKey(entry.getKey());
                byte[] value = this.buildSerializedValue(entry.getValue());
                writeBatchWrapper.put(this.table.getColumnFamilyHandle(), key, value);
            }
        }
    }

    public byte[] buildSerializedKey(UK userKey) throws IOException {
        this.key.setUserKey(userKey);
        return this.table.serializeKey(this.key);
    }

    public byte[] buildSerializedValue(UV singleValue) throws IOException {
        DataOutputSerializer outputView = this.valueSerializerView.get();
        outputView.clear();
        this.userValueSerializer.get().serialize(singleValue, (DataOutputView)outputView);
        return outputView.getCopyOfBuffer();
    }

    @VisibleForTesting
    public Map<?, ?> getBunchValue() {
        return (Map)this.value;
    }
}

