/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.sync;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.state.forst.sync.AbstractForStStateKeysIterator;
import org.apache.flink.state.forst.sync.ForStIteratorWrapper;
import org.apache.flink.util.FlinkRuntimeException;

public class ForStStateKeysIterator<K>
extends AbstractForStStateKeysIterator<K>
implements Iterator<K> {
    @Nonnull
    private final byte[] namespaceBytes;
    private K nextKey;
    private K previousKey;

    public ForStStateKeysIterator(@Nonnull ForStIteratorWrapper iterator, @Nonnull String state, @Nonnull TypeSerializer<K> keySerializer, int keyGroupPrefixBytes, boolean ambiguousKeyPossible, @Nonnull byte[] namespaceBytes) {
        super(iterator, state, keySerializer, keyGroupPrefixBytes, ambiguousKeyPossible);
        this.namespaceBytes = namespaceBytes;
        this.nextKey = null;
        this.previousKey = null;
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.nextKey == null && this.iterator.isValid()) {
                byte[] keyBytes = this.iterator.key();
                Object currentKey = this.deserializeKey(keyBytes, this.byteArrayDataInputView);
                int namespaceByteStartPos = this.byteArrayDataInputView.getPosition();
                if (this.isMatchingNameSpace(keyBytes, namespaceByteStartPos) && !Objects.equals(this.previousKey, currentKey)) {
                    this.previousKey = currentKey;
                    this.nextKey = currentKey;
                }
                this.iterator.next();
            }
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Failed to access state [" + this.state + "]", (Throwable)e);
        }
        return this.nextKey != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Failed to access state [" + this.state + "]");
        }
        K tmpKey = this.nextKey;
        this.nextKey = null;
        return tmpKey;
    }

    private boolean isMatchingNameSpace(@Nonnull byte[] key, int beginPos) {
        int namespaceBytesLength = this.namespaceBytes.length;
        int basicLength = namespaceBytesLength + beginPos;
        if (key.length >= basicLength) {
            for (int i = 0; i < namespaceBytesLength; ++i) {
                if (key[beginPos + i] == this.namespaceBytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

