/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.state.forst.ForStDBIterRequest;
import org.apache.flink.state.forst.ForStDBOperation;
import org.forstdb.RocksDB;

public class ForStIterateOperation
implements ForStDBOperation {
    public static final int CACHE_SIZE_LIMIT = 128;
    private final RocksDB db;
    private final List<ForStDBIterRequest<?, ?, ?, ?, ?>> batchRequest;
    private final Executor executor;
    private final Runnable subProcessFinished;

    ForStIterateOperation(RocksDB db, List<ForStDBIterRequest<?, ?, ?, ?, ?>> batchRequest, Executor executor) {
        this(db, batchRequest, executor, null);
    }

    ForStIterateOperation(RocksDB db, List<ForStDBIterRequest<?, ?, ?, ?, ?>> batchRequest, Executor executor, Runnable subProcessFinished) {
        this.db = db;
        this.batchRequest = batchRequest;
        this.executor = executor;
        this.subProcessFinished = subProcessFinished;
    }

    @Override
    public CompletableFuture<Void> process() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicReference error = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(this.batchRequest.size());
        for (int i = 0; i < this.batchRequest.size(); ++i) {
            ForStDBIterRequest<?, ?, ?, ?, ?> request = this.batchRequest.get(i);
            this.executor.execute(() -> {
                try {
                    if (error.get() == null) {
                        request.process(this.db, 128);
                    } else {
                        request.completeStateFutureExceptionally("Error when execute ForStDb iterate operation", (Throwable)error.get());
                    }
                }
                catch (Exception e) {
                    error.set(e);
                    request.completeStateFutureExceptionally("Error when execute ForStDb iterate operation", e);
                    future.completeExceptionally(e);
                }
                finally {
                    if (counter.decrementAndGet() == 0 && !future.isCompletedExceptionally()) {
                        future.complete(null);
                    }
                    if (this.subProcessFinished != null) {
                        this.subProcessFinished.run();
                    }
                }
            });
        }
        return future;
    }

    @Override
    public int subProcessCount() {
        return this.batchRequest.size();
    }
}

