/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.core.asyncprocessing.InternalAsyncFuture;
import org.apache.flink.state.forst.ContextKey;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStDBWriteBatchWrapper;
import org.apache.flink.state.forst.ForStInnerTable;
import org.forstdb.RocksDB;
import org.forstdb.RocksDBException;

public class ForStDBMultiRawMergePutRequest<K, N, V>
extends ForStDBPutRequest<K, N, V> {
    final Collection<byte[]> rawValue;

    ForStDBMultiRawMergePutRequest(ContextKey<K, N> key, Collection<byte[]> value, ForStInnerTable<K, N, V> table, InternalAsyncFuture<Void> future) {
        super(key, null, true, table, future);
        this.rawValue = value;
    }

    @Override
    public void process(ForStDBWriteBatchWrapper writeBatchWrapper, RocksDB db) throws IOException, RocksDBException {
        byte[] key = this.buildSerializedKey();
        for (byte[] value : this.rawValue) {
            writeBatchWrapper.merge(this.table.getColumnFamilyHandle(), key, value);
        }
    }
}

