/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.util.function.FunctionWithException;

@ThreadSafe
public class ContextKey<K, N> {
    private final RecordContext<K> recordContext;
    @Nullable
    private Object userKey;
    @Nullable
    private final N namespace;

    public ContextKey(RecordContext<K> recordContext, @Nullable N namespace) {
        this(recordContext, namespace, null);
    }

    public ContextKey(RecordContext<K> recordContext, @Nullable N namespace, Object userKey) {
        this.recordContext = recordContext;
        this.namespace = namespace;
        this.userKey = userKey;
    }

    public K getRawKey() {
        return (K)this.recordContext.getKey();
    }

    public int getKeyGroup() {
        return this.recordContext.getKeyGroup();
    }

    public N getNamespace() {
        return this.namespace;
    }

    public Object getUserKey() {
        return this.userKey;
    }

    public void setUserKey(Object userKey) {
        this.userKey = userKey;
        this.resetExtra();
    }

    public void resetExtra() {
        this.recordContext.setExtra(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getOrCreateSerializedKey(FunctionWithException<ContextKey<K, N>, byte[], IOException> serializeKeyFunc) throws IOException {
        byte[] serializedKey = (byte[])this.recordContext.getExtra();
        if (serializedKey != null) {
            return serializedKey;
        }
        RecordContext<K> recordContext = this.recordContext;
        synchronized (recordContext) {
            serializedKey = (byte[])this.recordContext.getExtra();
            if (serializedKey == null) {
                serializedKey = (byte[])serializeKeyFunc.apply((Object)this);
                this.recordContext.setExtra((Object)serializedKey);
            }
        }
        return serializedKey;
    }

    public int hashCode() {
        return Objects.hash(this.recordContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextKey that = (ContextKey)o;
        return Objects.equals(this.recordContext, that.recordContext);
    }

    public String toString() {
        return "ContextKey{recordCtx:" + this.recordContext.toString() + ", userKey:" + String.valueOf(this.userKey) + "}";
    }
}

