/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.sync;

import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.state.forst.ForStOptions;
import org.apache.flink.state.forst.ForStStateBackend;
import org.apache.flink.util.Preconditions;

public class ForStPriorityQueueConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int UNDEFINED_ROCKSDB_PRIORITY_QUEUE_SET_CACHE_SIZE = -1;
    @Nullable
    private ForStStateBackend.PriorityQueueStateType priorityQueueStateType;
    private int rocksDBPriorityQueueSetCacheSize;

    public ForStPriorityQueueConfig() {
        this(null, -1);
    }

    public ForStPriorityQueueConfig(ForStStateBackend.PriorityQueueStateType priorityQueueStateType, int rocksDBPriorityQueueSetCacheSize) {
        this.priorityQueueStateType = priorityQueueStateType;
        this.rocksDBPriorityQueueSetCacheSize = rocksDBPriorityQueueSetCacheSize;
    }

    public ForStStateBackend.PriorityQueueStateType getPriorityQueueStateType() {
        return this.priorityQueueStateType == null ? (ForStStateBackend.PriorityQueueStateType)((Object)ForStOptions.TIMER_SERVICE_FACTORY.defaultValue()) : this.priorityQueueStateType;
    }

    public void setPriorityQueueStateType(ForStStateBackend.PriorityQueueStateType type) {
        this.priorityQueueStateType = (ForStStateBackend.PriorityQueueStateType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
    }

    public int getRocksDBPriorityQueueSetCacheSize() {
        return this.rocksDBPriorityQueueSetCacheSize == -1 ? (Integer)ForStOptions.FORST_TIMER_SERVICE_FACTORY_CACHE_SIZE.defaultValue() : this.rocksDBPriorityQueueSetCacheSize;
    }

    public static ForStPriorityQueueConfig fromOtherAndConfiguration(ForStPriorityQueueConfig other, ReadableConfig config) {
        ForStStateBackend.PriorityQueueStateType priorityQueueType = null == other.priorityQueueStateType ? (ForStStateBackend.PriorityQueueStateType)((Object)config.get(ForStOptions.TIMER_SERVICE_FACTORY)) : other.priorityQueueStateType;
        int cacheSize = other.rocksDBPriorityQueueSetCacheSize == -1 ? (Integer)config.get(ForStOptions.FORST_TIMER_SERVICE_FACTORY_CACHE_SIZE) : other.rocksDBPriorityQueueSetCacheSize;
        return new ForStPriorityQueueConfig(priorityQueueType, cacheSize);
    }

    public static ForStPriorityQueueConfig buildWithPriorityQueueType(ForStStateBackend.PriorityQueueStateType type) {
        return new ForStPriorityQueueConfig(type, (Integer)ForStOptions.FORST_TIMER_SERVICE_FACTORY_CACHE_SIZE.defaultValue());
    }
}

