/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.ICloseableRegistry;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.metainfo.StateMetaInfoSnapshot;
import org.apache.flink.state.forst.ForStDBTtlCompactFiltersManager;
import org.apache.flink.state.forst.ForStNativeMetricMonitor;
import org.apache.flink.state.forst.ForStNativeMetricOptions;
import org.apache.flink.state.forst.ForStOperationUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.forstdb.ColumnFamilyDescriptor;
import org.forstdb.ColumnFamilyHandle;
import org.forstdb.ColumnFamilyOptions;
import org.forstdb.DBOptions;
import org.forstdb.ExportImportFilesMetaData;
import org.forstdb.RocksDB;

class ForStHandle
implements AutoCloseable {
    private final Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory;
    private final DBOptions dbOptions;
    private final Map<String, ForStOperationUtils.ForStKvStateInfo> kvStateInformation;
    private final String dbPath;
    private List<ColumnFamilyHandle> columnFamilyHandles;
    private List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    private final ForStNativeMetricOptions nativeMetricOptions;
    private final MetricGroup metricGroup;
    private final ForStDBTtlCompactFiltersManager ttlCompactFiltersManager;
    private final Long writeBufferManagerCapacity;
    private RocksDB db;
    private ColumnFamilyHandle defaultColumnFamilyHandle;
    @Nullable
    private ForStNativeMetricMonitor nativeMetricMonitor;

    protected ForStHandle(Map<String, ForStOperationUtils.ForStKvStateInfo> kvStateInformation, Path instanceRocksDBPath, DBOptions dbOptions, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, ForStNativeMetricOptions nativeMetricOptions, MetricGroup metricGroup, ForStDBTtlCompactFiltersManager ttlCompactFiltersManager, Long writeBufferManagerCapacity) {
        this.kvStateInformation = kvStateInformation;
        this.dbPath = instanceRocksDBPath.getPath();
        this.dbOptions = dbOptions;
        this.columnFamilyOptionsFactory = columnFamilyOptionsFactory;
        this.nativeMetricOptions = nativeMetricOptions;
        this.metricGroup = metricGroup;
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(1);
        this.columnFamilyDescriptors = Collections.emptyList();
        this.ttlCompactFiltersManager = ttlCompactFiltersManager;
        this.writeBufferManagerCapacity = writeBufferManagerCapacity;
    }

    void openDB() throws IOException {
        this.loadDb();
    }

    void openDB(@Nonnull List<ColumnFamilyDescriptor> columnFamilyDescriptors, @Nonnull List<StateMetaInfoSnapshot> stateMetaInfoSnapshots, @Nonnull ICloseableRegistry cancelStreamRegistryForRestore) throws IOException {
        this.columnFamilyDescriptors = columnFamilyDescriptors;
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(columnFamilyDescriptors.size() + 1);
        this.loadDb();
        for (int i = 0; i < stateMetaInfoSnapshots.size(); ++i) {
            this.getOrRegisterStateColumnFamilyHandle(this.columnFamilyHandles.get(i), stateMetaInfoSnapshots.get(i), cancelStreamRegistryForRestore);
        }
    }

    private void loadDb() throws IOException {
        this.db = ForStOperationUtils.openDB(this.dbPath, this.columnFamilyDescriptors, this.columnFamilyHandles, ForStOperationUtils.createColumnFamilyOptions(this.columnFamilyOptionsFactory, "default"), this.dbOptions);
        this.defaultColumnFamilyHandle = this.columnFamilyHandles.remove(0);
        this.nativeMetricMonitor = this.nativeMetricOptions.isEnabled() ? new ForStNativeMetricMonitor(this.nativeMetricOptions, this.metricGroup, this.db, this.dbOptions.statistics()) : null;
    }

    ForStOperationUtils.ForStKvStateInfo getOrRegisterStateColumnFamilyHandle(ColumnFamilyHandle columnFamilyHandle, StateMetaInfoSnapshot stateMetaInfoSnapshot, ICloseableRegistry cancelStreamRegistryForRestore) {
        ForStOperationUtils.ForStKvStateInfo registeredStateMetaInfoEntry = this.kvStateInformation.get(stateMetaInfoSnapshot.getName());
        if (null == registeredStateMetaInfoEntry) {
            RegisteredStateMetaInfoBase stateMetaInfo = RegisteredStateMetaInfoBase.fromMetaInfoSnapshot((StateMetaInfoSnapshot)stateMetaInfoSnapshot);
            registeredStateMetaInfoEntry = columnFamilyHandle == null ? ForStOperationUtils.createStateInfo(stateMetaInfo, this.db, this.columnFamilyOptionsFactory, this.ttlCompactFiltersManager, this.writeBufferManagerCapacity, cancelStreamRegistryForRestore) : new ForStOperationUtils.ForStKvStateInfo(columnFamilyHandle, stateMetaInfo);
            ForStOperationUtils.registerKvStateInformation(this.kvStateInformation, this.nativeMetricMonitor, stateMetaInfoSnapshot.getName(), registeredStateMetaInfoEntry);
        }
        return registeredStateMetaInfoEntry;
    }

    void registerStateColumnFamilyHandleWithImport(RegisteredStateMetaInfoBase.Key stateMetaInfoKey, List<ExportImportFilesMetaData> cfMetaDataList, ICloseableRegistry cancelStreamRegistryForRestore) {
        RegisteredStateMetaInfoBase stateMetaInfo = stateMetaInfoKey.getRegisteredStateMetaInfoBase();
        Preconditions.checkState((!this.kvStateInformation.containsKey(stateMetaInfo.getName()) ? 1 : 0) != 0, (Object)("Error: stateMetaInfo.name is not unique:" + stateMetaInfo.getName()));
        ForStOperationUtils.ForStKvStateInfo stateInfo = ForStOperationUtils.createStateInfo(stateMetaInfo, this.db, this.columnFamilyOptionsFactory, this.ttlCompactFiltersManager, this.writeBufferManagerCapacity, cfMetaDataList, cancelStreamRegistryForRestore);
        ForStOperationUtils.registerKvStateInformation(this.kvStateInformation, this.nativeMetricMonitor, stateMetaInfo.getName(), stateInfo);
        this.columnFamilyHandles.add(stateInfo.columnFamilyHandle);
    }

    public RocksDB getDb() {
        return this.db;
    }

    @Nullable
    public ForStNativeMetricMonitor getNativeMetricMonitor() {
        return this.nativeMetricMonitor;
    }

    public List<ColumnFamilyHandle> getColumnFamilyHandles() {
        return this.columnFamilyHandles;
    }

    public ColumnFamilyHandle getDefaultColumnFamilyHandle() {
        return this.defaultColumnFamilyHandle;
    }

    public Function<String, ColumnFamilyOptions> getColumnFamilyOptionsFactory() {
        return this.columnFamilyOptionsFactory;
    }

    public ForStDBTtlCompactFiltersManager getTtlCompactFiltersManager() {
        return this.ttlCompactFiltersManager;
    }

    public Long getWriteBufferManagerCapacity() {
        return this.writeBufferManagerCapacity;
    }

    public DBOptions getDbOptions() {
        return this.dbOptions;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.defaultColumnFamilyHandle);
        IOUtils.closeQuietly((AutoCloseable)this.nativeMetricMonitor);
        IOUtils.closeQuietly((AutoCloseable)this.db);
        this.columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
    }
}

