/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.restore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.state.forst.ForStNativeMetricMonitor;
import org.apache.flink.state.forst.ForStNativeMetricOptions;
import org.apache.flink.state.forst.ForStOperationUtils;
import org.apache.flink.util.IOUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;

class ForStHandle
implements AutoCloseable {
    private final Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory;
    private final DBOptions dbOptions;
    private final String dbPath;
    private final List<ColumnFamilyHandle> columnFamilyHandles;
    private final List<ColumnFamilyDescriptor> columnFamilyDescriptors;
    private final ForStNativeMetricOptions nativeMetricOptions;
    private final MetricGroup metricGroup;
    private RocksDB db;
    private ColumnFamilyHandle defaultColumnFamilyHandle;
    @Nullable
    private ForStNativeMetricMonitor nativeMetricMonitor;

    protected ForStHandle(File instanceRocksDBPath, DBOptions dbOptions, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, ForStNativeMetricOptions nativeMetricOptions, MetricGroup metricGroup) {
        this.dbPath = instanceRocksDBPath.getAbsolutePath();
        this.dbOptions = dbOptions;
        this.columnFamilyOptionsFactory = columnFamilyOptionsFactory;
        this.nativeMetricOptions = nativeMetricOptions;
        this.metricGroup = metricGroup;
        this.columnFamilyHandles = new ArrayList<ColumnFamilyHandle>(1);
        this.columnFamilyDescriptors = Collections.emptyList();
    }

    void openDB() throws IOException {
        this.loadDb();
    }

    private void loadDb() throws IOException {
        this.db = ForStOperationUtils.openDB(this.dbPath, this.columnFamilyDescriptors, this.columnFamilyHandles, ForStOperationUtils.createColumnFamilyOptions(this.columnFamilyOptionsFactory, "default"), this.dbOptions);
        this.defaultColumnFamilyHandle = this.columnFamilyHandles.remove(0);
        this.nativeMetricMonitor = this.nativeMetricOptions.isEnabled() ? new ForStNativeMetricMonitor(this.nativeMetricOptions, this.metricGroup, this.db, this.dbOptions.statistics()) : null;
    }

    public RocksDB getDb() {
        return this.db;
    }

    @Nullable
    public ForStNativeMetricMonitor getNativeMetricMonitor() {
        return this.nativeMetricMonitor;
    }

    public ColumnFamilyHandle getDefaultColumnFamilyHandle() {
        return this.defaultColumnFamilyHandle;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.defaultColumnFamilyHandle);
        IOUtils.closeQuietly((AutoCloseable)this.nativeMetricMonitor);
        IOUtils.closeQuietly((AutoCloseable)this.db);
        this.columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
    }
}

