/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.state.forst.fs.ByteBufferReadableFSDataInputStream;
import org.apache.flink.state.forst.fs.ByteBufferWritableFSDataOutputStream;
import org.apache.flink.util.Preconditions;

@Experimental
public class ForStFlinkFileSystem
extends FileSystem {
    private static final int DEFAULT_INPUT_STREAM_CAPACITY = 32;
    private final FileSystem delegateFS;

    public ForStFlinkFileSystem(FileSystem delegateFS) {
        this.delegateFS = delegateFS;
    }

    public static FileSystem get(URI uri) throws IOException {
        return new ForStFlinkFileSystem(FileSystem.get((URI)uri));
    }

    public ByteBufferWritableFSDataOutputStream create(Path path) throws IOException {
        return this.create(path, FileSystem.WriteMode.OVERWRITE);
    }

    public ByteBufferWritableFSDataOutputStream create(Path path, FileSystem.WriteMode overwriteMode) throws IOException {
        return new ByteBufferWritableFSDataOutputStream(this.delegateFS.create(path, overwriteMode));
    }

    public ByteBufferReadableFSDataInputStream open(Path path, int bufferSize) throws IOException {
        FileStatus fileStatus = (FileStatus)Preconditions.checkNotNull((Object)this.getFileStatus(path));
        return new ByteBufferReadableFSDataInputStream(() -> this.delegateFS.open(path, bufferSize), 32, fileStatus.getLen());
    }

    public ByteBufferReadableFSDataInputStream open(Path path) throws IOException {
        FileStatus fileStatus = (FileStatus)Preconditions.checkNotNull((Object)this.getFileStatus(path));
        return new ByteBufferReadableFSDataInputStream(() -> this.delegateFS.open(path), 32, fileStatus.getLen());
    }

    public boolean rename(Path src, Path dst) throws IOException {
        boolean deleted;
        if (this.delegateFS.exists(dst) && !(deleted = this.delegateFS.delete(dst, false))) {
            throw new IOException("Fail to delete dst path: " + dst);
        }
        return this.delegateFS.rename(src, dst);
    }

    public Path getWorkingDirectory() {
        return this.delegateFS.getWorkingDirectory();
    }

    public Path getHomeDirectory() {
        return this.delegateFS.getHomeDirectory();
    }

    public URI getUri() {
        return this.delegateFS.getUri();
    }

    public FileStatus getFileStatus(Path path) throws IOException {
        return this.delegateFS.getFileStatus(path);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.delegateFS.getFileBlockLocations(file, start, len);
    }

    public FileStatus[] listStatus(Path path) throws IOException {
        return this.delegateFS.listStatus(path);
    }

    public boolean delete(Path path, boolean recursive) throws IOException {
        return this.delegateFS.delete(path, recursive);
    }

    public boolean mkdirs(Path path) throws IOException {
        return this.delegateFS.mkdirs(path);
    }

    public boolean isDistributedFS() {
        return this.delegateFS.isDistributedFS();
    }

    public FileSystemKind getKind() {
        return this.delegateFS.getKind();
    }
}

