/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.core.fs.ByteBufferReadable;
import org.apache.flink.core.fs.FSDataInputStream;

@Experimental
public class ByteBufferReadableFSDataInputStream
extends FSDataInputStream {
    private final FSDataInputStream originalInputStream;
    private final Queue<FSDataInputStream> readInputStreamPool;
    private final Callable<FSDataInputStream> inputStreamBuilder;
    private final long totalFileSize;

    public ByteBufferReadableFSDataInputStream(Callable<FSDataInputStream> inputStreamBuilder, int inputStreamCapacity, long totalFileSize) throws IOException {
        try {
            this.originalInputStream = inputStreamBuilder.call();
        }
        catch (Exception e) {
            throw new IOException("Exception when build original input stream", e);
        }
        this.inputStreamBuilder = inputStreamBuilder;
        this.readInputStreamPool = new LinkedBlockingQueue<FSDataInputStream>(inputStreamCapacity);
        this.totalFileSize = totalFileSize;
    }

    public int readFully(ByteBuffer bb) throws IOException {
        if (bb == null) {
            throw new NullPointerException();
        }
        if (bb.remaining() == 0) {
            return 0;
        }
        return this.originalInputStream instanceof ByteBufferReadable ? ((ByteBufferReadable)this.originalInputStream).read(bb) : this.readFullyFromFSDataInputStream(this.originalInputStream, bb);
    }

    public int readFully(long position, ByteBuffer bb) throws Exception {
        boolean offered;
        int result;
        if (bb == null) {
            throw new NullPointerException();
        }
        if (position >= this.totalFileSize) {
            throw new IllegalArgumentException(String.format("position [%s] is larger than or equals to totalFileSize [%s]", position, this.totalFileSize));
        }
        bb.limit(Math.min(bb.limit(), (int)Math.min(this.totalFileSize - position + (long)bb.position(), Integer.MAX_VALUE)));
        if (bb.remaining() == 0) {
            return 0;
        }
        FSDataInputStream fsDataInputStream = this.readInputStreamPool.poll();
        if (fsDataInputStream == null) {
            fsDataInputStream = this.inputStreamBuilder.call();
        }
        if (fsDataInputStream instanceof ByteBufferReadable) {
            result = ((ByteBufferReadable)fsDataInputStream).read(position, bb);
        } else {
            fsDataInputStream.seek(position);
            result = this.readFullyFromFSDataInputStream(fsDataInputStream, bb);
        }
        try {
            offered = this.readInputStreamPool.offer(fsDataInputStream);
        }
        catch (Exception ex) {
            fsDataInputStream.close();
            throw ex;
        }
        if (!offered) {
            fsDataInputStream.close();
        }
        return result;
    }

    private int readFullyFromFSDataInputStream(FSDataInputStream originalInputStream, ByteBuffer bb) throws IOException {
        int n;
        int c = originalInputStream.read();
        if (c == -1) {
            return -1;
        }
        bb.put((byte)c);
        int len = bb.remaining() + 1;
        for (n = 1; n < len && (c = originalInputStream.read()) != -1; ++n) {
            bb.put((byte)c);
        }
        return n;
    }

    public void seek(long desired) throws IOException {
        this.originalInputStream.seek(desired);
    }

    public long getPos() throws IOException {
        return this.originalInputStream.getPos();
    }

    public int read() throws IOException {
        return this.originalInputStream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.originalInputStream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.originalInputStream.read(b, off, len);
    }

    public long skip(long n) throws IOException {
        long position = this.getPos();
        this.seek(position + n);
        return this.getPos() - position;
    }

    public int available() throws IOException {
        return this.originalInputStream.available();
    }

    public void close() throws IOException {
        this.originalInputStream.close();
        for (FSDataInputStream fsDataInputStream : this.readInputStreamPool) {
            fsDataInputStream.close();
        }
    }

    public synchronized void mark(int readlimit) {
        this.originalInputStream.mark(readlimit);
    }

    public synchronized void reset() throws IOException {
        this.originalInputStream.reset();
    }

    public boolean markSupported() {
        return this.originalInputStream.markSupported();
    }
}

