/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestContainer;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBPutRequest;
import org.apache.flink.state.forst.ForStValueState;

public class ForStStateRequestClassifier
implements StateRequestContainer {
    private final List<ForStDBGetRequest<?, ?>> dbGetRequests = new ArrayList();
    private final List<ForStDBPutRequest<?, ?>> dbPutRequests = new ArrayList();

    public void offer(StateRequest<?, ?, ?> stateRequest) {
        this.convertStateRequestsToForStDBRequests(stateRequest);
    }

    public boolean isEmpty() {
        return this.dbGetRequests.isEmpty() && this.dbPutRequests.isEmpty();
    }

    private void convertStateRequestsToForStDBRequests(StateRequest<?, ?, ?> stateRequest) {
        StateRequestType stateRequestType = stateRequest.getRequestType();
        switch (stateRequestType) {
            case VALUE_GET: {
                ForStValueState forStValueState = (ForStValueState)stateRequest.getState();
                this.dbGetRequests.add(forStValueState.buildDBGetRequest(stateRequest));
                return;
            }
            case VALUE_UPDATE: {
                ForStValueState forStValueState = (ForStValueState)stateRequest.getState();
                this.dbPutRequests.add(forStValueState.buildDBPutRequest(stateRequest));
                return;
            }
            case CLEAR: {
                if (stateRequest.getState() instanceof ForStValueState) {
                    ForStValueState forStValueState = (ForStValueState)stateRequest.getState();
                    this.dbPutRequests.add(forStValueState.buildDBPutRequest(stateRequest));
                    return;
                }
                throw new UnsupportedOperationException("The State " + stateRequest.getState().getClass() + " doesn't yet support the clear method.");
            }
        }
        throw new UnsupportedOperationException("Unsupported state request type:" + stateRequestType);
    }

    public List<ForStDBGetRequest<?, ?>> pollDbGetRequests() {
        return this.dbGetRequests;
    }

    public List<ForStDBPutRequest<?, ?>> pollDbPutRequests() {
        return this.dbPutRequests;
    }
}

