/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.TextElement;

@Experimental
public class ForStOptions {
    public static final ConfigOption<String> LOCAL_DIRECTORIES = ConfigOptions.key((String)"state.backend.forst.local-dir").stringType().noDefaultValue().withDescription(Description.builder().text("The local directory (on the TaskManager) where ForSt puts some meta files. Per default, it will be <WORKING_DIR>/tmp. See %s for more details.", new InlineElement[]{TextElement.code((String)ClusterOptions.TASK_MANAGER_PROCESS_WORKING_DIR_BASE.key())}).build());
    public static final ConfigOption<String> REMOTE_DIRECTORY = ConfigOptions.key((String)"state.backend.forst.remote-dir").stringType().noDefaultValue().withDescription(String.format("The remote directory where ForSt puts its SST files, fallback to %s if not configured.", LOCAL_DIRECTORIES.key()));
    public static final ConfigOption<String> OPTIONS_FACTORY = ConfigOptions.key((String)"state.backend.forst.options-factory").stringType().noDefaultValue().withDescription("The options factory class for users to add customized options in DBOptions and ColumnFamilyOptions for ForSt. If set, the ForSt state backend will load the class and apply configs to DBOptions and ColumnFamilyOptions after loading ones from 'ForStConfigurableOptions' and pre-defined options.");
    public static final ConfigOption<Boolean> USE_MANAGED_MEMORY = ConfigOptions.key((String)"state.backend.forst.memory.managed").booleanType().defaultValue((Object)true).withDescription("If set, the ForSt state backend will automatically configure itself to use the managed memory budget of the task slot, and divide the memory over write buffers, indexes, block caches, etc. That way, the three major uses of memory of ForSt will be capped.");
    public static final ConfigOption<MemorySize> FIX_PER_SLOT_MEMORY_SIZE = ConfigOptions.key((String)"state.backend.forst.memory.fixed-per-slot").memoryType().noDefaultValue().withDescription(String.format("The fixed total amount of memory, shared among all ForSt instances per slot. This option overrides the '%s' option when configured.", USE_MANAGED_MEMORY.key()));
    public static final ConfigOption<MemorySize> FIX_PER_TM_MEMORY_SIZE = ConfigOptions.key((String)"state.backend.forst.memory.fixed-per-tm").memoryType().noDefaultValue().withDescription(String.format("The fixed total amount of memory, shared among all ForSt instances per Task Manager (cluster-level option). This option only takes effect if neither '%s' nor '%s' are not configured. If none is configured then each ForSt column family state has its own memory caches (as controlled by the column family options). The relevant options for the shared resources (e.g. write-buffer-ratio) can be set on the same level (config.yaml).Note, that this feature breaks resource isolation between the slots", USE_MANAGED_MEMORY.key(), FIX_PER_SLOT_MEMORY_SIZE.key()));
    public static final ConfigOption<Double> WRITE_BUFFER_RATIO = ConfigOptions.key((String)"state.backend.forst.memory.write-buffer-ratio").doubleType().defaultValue((Object)0.5).withDescription(String.format("The maximum amount of memory that write buffers may take, as a fraction of the total shared memory. This option only has an effect when '%s' or '%s' are configured.", USE_MANAGED_MEMORY.key(), FIX_PER_SLOT_MEMORY_SIZE.key()));
    public static final ConfigOption<Double> HIGH_PRIORITY_POOL_RATIO = ConfigOptions.key((String)"state.backend.forst.memory.high-prio-pool-ratio").doubleType().defaultValue((Object)0.1).withDescription(String.format("The fraction of cache memory that is reserved for high-priority data like index, filter, and compression dictionary blocks. This option only has an effect when '%s' or '%s' are configured.", USE_MANAGED_MEMORY.key(), FIX_PER_SLOT_MEMORY_SIZE.key()));
    public static final ConfigOption<Boolean> USE_PARTITIONED_INDEX_FILTERS = ConfigOptions.key((String)"state.backend.forst.memory.partitioned-index-filters").booleanType().defaultValue((Object)false).withDescription(String.format("With partitioning, the index/filter block of an SST file is partitioned into smaller blocks with an additional top-level index on them. When reading an index/filter, only top-level index is loaded into memory. The partitioned index/filter then uses the top-level index to load on demand into the block cache the partitions that are required to perform the index/filter query. This option only has an effect when '%s' or '%s' are configured.", USE_MANAGED_MEMORY.key(), FIX_PER_SLOT_MEMORY_SIZE.key()));
}

