/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.memory.OpaqueMemoryResource;
import org.apache.flink.state.forst.ForStMemoryConfiguration;
import org.apache.flink.state.forst.ForStMemoryControllerUtils;
import org.apache.flink.state.forst.ForStSharedResources;
import org.apache.flink.state.forst.ForStSharedResourcesFactory;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.OperatingSystem;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;

public class ForStOperationUtils {
    public static final String MERGE_OPERATOR_NAME = "stringappendtest";

    public static RocksDB openDB(String path, List<ColumnFamilyDescriptor> stateColumnFamilyDescriptors, List<ColumnFamilyHandle> stateColumnFamilyHandles, ColumnFamilyOptions columnFamilyOptions, DBOptions dbOptions) throws IOException {
        RocksDB dbRef;
        ArrayList<ColumnFamilyDescriptor> columnFamilyDescriptors = new ArrayList<ColumnFamilyDescriptor>(1 + stateColumnFamilyDescriptors.size());
        columnFamilyDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, columnFamilyOptions));
        columnFamilyDescriptors.addAll(stateColumnFamilyDescriptors);
        try {
            dbRef = RocksDB.open((DBOptions)((DBOptions)Preconditions.checkNotNull((Object)dbOptions)), (String)((String)Preconditions.checkNotNull((Object)path)), columnFamilyDescriptors, stateColumnFamilyHandles);
        }
        catch (RocksDBException e) {
            IOUtils.closeQuietly((AutoCloseable)columnFamilyOptions);
            columnFamilyDescriptors.forEach(cfd -> IOUtils.closeQuietly((AutoCloseable)cfd.getOptions()));
            ForStOperationUtils.throwExceptionIfPathLengthExceededOnWindows(path, (Exception)((Object)e));
            throw new IOException("Error while opening ForSt instance.", e);
        }
        Preconditions.checkState((1 + stateColumnFamilyDescriptors.size() == stateColumnFamilyHandles.size() ? 1 : 0) != 0, (Object)"Not all requested column family handles have been created");
        return dbRef;
    }

    public static ColumnFamilyHandle createColumnFamilyHandle(String stateId, RocksDB db, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory) {
        ColumnFamilyHandle columnFamilyHandle;
        ColumnFamilyDescriptor columnFamilyDescriptor = ForStOperationUtils.createColumnFamilyDescriptor(stateId, columnFamilyOptionsFactory);
        try {
            columnFamilyHandle = ForStOperationUtils.createColumnFamily(columnFamilyDescriptor, db);
        }
        catch (Exception ex) {
            IOUtils.closeQuietly((AutoCloseable)columnFamilyDescriptor.getOptions());
            throw new FlinkRuntimeException("Error creating ColumnFamilyHandle.", (Throwable)ex);
        }
        return columnFamilyHandle;
    }

    public static ColumnFamilyDescriptor createColumnFamilyDescriptor(String stateId, Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory) {
        byte[] nameBytes = stateId.getBytes(ConfigConstants.DEFAULT_CHARSET);
        Preconditions.checkState((!Arrays.equals(RocksDB.DEFAULT_COLUMN_FAMILY, nameBytes) ? 1 : 0) != 0, (Object)"The chosen state name 'default' collides with the name of the default column family!");
        ColumnFamilyOptions options = ForStOperationUtils.createColumnFamilyOptions(columnFamilyOptionsFactory, stateId);
        return new ColumnFamilyDescriptor(nameBytes, options);
    }

    private static ColumnFamilyHandle createColumnFamily(ColumnFamilyDescriptor columnDescriptor, RocksDB db) throws RocksDBException {
        return db.createColumnFamily(columnDescriptor);
    }

    public static ColumnFamilyOptions createColumnFamilyOptions(Function<String, ColumnFamilyOptions> columnFamilyOptionsFactory, String stateName) {
        return columnFamilyOptionsFactory.apply(stateName).setMergeOperatorName(MERGE_OPERATOR_NAME);
    }

    @Nullable
    public static OpaqueMemoryResource<ForStSharedResources> allocateSharedCachesIfConfigured(ForStMemoryConfiguration jobMemoryConfig, Environment env, double memoryFraction, Logger logger, ForStMemoryControllerUtils.ForStMemoryFactory forStMemoryFactory) throws IOException {
        try {
            ForStSharedResourcesFactory factory = ForStSharedResourcesFactory.from(jobMemoryConfig, env);
            if (factory == null) {
                return null;
            }
            return factory.create(jobMemoryConfig, env, memoryFraction, logger, forStMemoryFactory);
        }
        catch (Exception e) {
            throw new IOException("Failed to acquire shared cache resource for ForSt", e);
        }
    }

    private static void throwExceptionIfPathLengthExceededOnWindows(String path, Exception cause) throws IOException {
        int maxWinDirPathLen = 247;
        if (path.length() > 247 && OperatingSystem.isWindows()) {
            throw new IOException(String.format("The directory path length (%d) is longer than the directory path length limit for Windows (%d): %s", path.length(), 247, path), cause);
        }
    }
}

