/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.state.forst.ForStDBGetRequest;
import org.apache.flink.state.forst.ForStDBOperation;
import org.rocksdb.RocksDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForStGeneralMultiGetOperation
implements ForStDBOperation {
    private static final Logger LOG = LoggerFactory.getLogger(ForStGeneralMultiGetOperation.class);
    private final RocksDB db;
    private final List<ForStDBGetRequest<?, ?>> batchRequest;
    private final Executor executor;

    ForStGeneralMultiGetOperation(RocksDB db, List<ForStDBGetRequest<?, ?>> batchRequest, Executor executor) {
        this.db = db;
        this.batchRequest = batchRequest;
        this.executor = executor;
    }

    @Override
    public CompletableFuture<Void> process() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        AtomicReference error = new AtomicReference();
        AtomicInteger counter = new AtomicInteger(this.batchRequest.size());
        for (int i = 0; i < this.batchRequest.size(); ++i) {
            ForStDBGetRequest<?, ?> request = this.batchRequest.get(i);
            this.executor.execute(() -> {
                try {
                    if (error.get() == null) {
                        byte[] key = request.buildSerializedKey();
                        byte[] value = this.db.get(request.getColumnFamilyHandle(), key);
                        request.completeStateFuture(value);
                    } else {
                        request.completeStateFutureExceptionally("Error already occurred in other state request of the same group, failed the state request directly", (Throwable)error.get());
                    }
                }
                catch (Exception e) {
                    error.set(e);
                    request.completeStateFutureExceptionally("Error when execute ForStDb get operation", e);
                    future.completeExceptionally(e);
                }
                finally {
                    if (counter.decrementAndGet() == 0 && !future.isCompletedExceptionally()) {
                        future.complete(null);
                    }
                }
            });
        }
        return future;
    }
}

