/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.forst;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.core.state.InternalStateFuture;
import org.apache.flink.state.forst.ForStInnerTable;
import org.rocksdb.ColumnFamilyHandle;

public class ForStDBPutRequest<K, V> {
    private final K key;
    @Nullable
    private final V value;
    private final ForStInnerTable<K, V> table;
    private final InternalStateFuture<Void> future;

    private ForStDBPutRequest(K key, V value, ForStInnerTable<K, V> table, InternalStateFuture<Void> future) {
        this.key = key;
        this.value = value;
        this.table = table;
        this.future = future;
    }

    public boolean valueIsNull() {
        return this.value == null;
    }

    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.table.getColumnFamilyHandle();
    }

    public byte[] buildSerializedKey() throws IOException {
        return this.table.serializeKey(this.key);
    }

    public byte[] buildSerializedValue() throws IOException {
        assert (this.value != null);
        return this.table.serializeValue(this.value);
    }

    public void completeStateFuture() {
        this.future.complete(null);
    }

    public void completeStateFutureExceptionally(String message, Throwable ex) {
        this.future.completeExceptionally(message, ex);
    }

    static <K, V> ForStDBPutRequest<K, V> of(K key, @Nullable V value, ForStInnerTable<K, V> table, InternalStateFuture<Void> future) {
        return new ForStDBPutRequest<K, V>(key, value, table, future);
    }
}

