/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api;

import java.io.IOException;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.metadata.CheckpointMetadata;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.WindowSavepointReader;
import org.apache.flink.state.api.functions.KeyedStateReaderFunction;
import org.apache.flink.state.api.input.BroadcastStateInputFormat;
import org.apache.flink.state.api.input.KeyedStateInputFormat;
import org.apache.flink.state.api.input.ListStateInputFormat;
import org.apache.flink.state.api.input.SourceBuilder;
import org.apache.flink.state.api.input.UnionStateInputFormat;
import org.apache.flink.state.api.input.operator.KeyedStateReaderOperator;
import org.apache.flink.state.api.runtime.MutableConfig;
import org.apache.flink.state.api.runtime.SavepointLoader;
import org.apache.flink.state.api.runtime.metadata.SavepointMetadataV2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.windowing.assigners.WindowAssigner;
import org.apache.flink.streaming.api.windowing.windows.Window;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SavepointReader {
    private final StreamExecutionEnvironment env;
    private final SavepointMetadataV2 metadata;
    @Nullable
    private final StateBackend stateBackend;

    public static SavepointReader read(StreamExecutionEnvironment env, String path) throws IOException {
        CheckpointMetadata metadata = SavepointLoader.loadSavepointMetadata(path);
        int maxParallelism = metadata.getOperatorStates().stream().map(OperatorState::getMaxParallelism).max(Comparator.naturalOrder()).orElseThrow(() -> new RuntimeException("Savepoint must contain at least one operator state."));
        SavepointMetadataV2 savepointMetadata = new SavepointMetadataV2(maxParallelism, metadata.getMasterStates(), metadata.getOperatorStates());
        return new SavepointReader(env, savepointMetadata, null);
    }

    public static SavepointReader read(StreamExecutionEnvironment env, String path, StateBackend stateBackend) throws IOException {
        CheckpointMetadata metadata = SavepointLoader.loadSavepointMetadata(path);
        int maxParallelism = metadata.getOperatorStates().stream().map(OperatorState::getMaxParallelism).max(Comparator.naturalOrder()).orElseThrow(() -> new RuntimeException("Savepoint must contain at least one operator state."));
        SavepointMetadataV2 savepointMetadata = new SavepointMetadataV2(maxParallelism, metadata.getMasterStates(), metadata.getOperatorStates());
        return new SavepointReader(env, savepointMetadata, stateBackend);
    }

    SavepointReader(StreamExecutionEnvironment env, SavepointMetadataV2 metadata, @Nullable StateBackend stateBackend) {
        Preconditions.checkNotNull((Object)env, (String)"The execution environment must not be null");
        Preconditions.checkNotNull((Object)metadata, (String)"The savepoint metadata must not be null");
        this.env = env;
        this.metadata = metadata;
        this.stateBackend = stateBackend;
    }

    @Deprecated
    public <T> DataStream<T> readListState(String uid, String name, TypeInformation<T> typeInfo) throws IOException {
        return this.readListState(OperatorIdentifier.forUid(uid), name, typeInfo);
    }

    public <T> DataStream<T> readListState(OperatorIdentifier identifier, String name, TypeInformation<T> typeInfo) throws IOException {
        return this.readListState(identifier, typeInfo, new ListStateDescriptor(name, typeInfo));
    }

    @Deprecated
    public <T> DataStream<T> readListState(String uid, String name, TypeInformation<T> typeInfo, TypeSerializer<T> serializer) throws IOException {
        return this.readListState(OperatorIdentifier.forUid(uid), name, typeInfo, serializer);
    }

    public <T> DataStream<T> readListState(OperatorIdentifier identifier, String name, TypeInformation<T> typeInfo, TypeSerializer<T> serializer) throws IOException {
        return this.readListState(identifier, typeInfo, new ListStateDescriptor(name, serializer));
    }

    private <T> DataStream<T> readListState(OperatorIdentifier identifier, TypeInformation<T> typeInfo, ListStateDescriptor<T> descriptor) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(identifier);
        ListStateInputFormat<T> inputFormat = new ListStateInputFormat<T>(operatorState, MutableConfig.of(this.env.getConfiguration()), this.stateBackend, descriptor, this.env.getConfig());
        return SourceBuilder.fromFormat(this.env, inputFormat, typeInfo);
    }

    @Deprecated
    public <T> DataStream<T> readUnionState(String uid, String name, TypeInformation<T> typeInfo) throws IOException {
        return this.readListState(OperatorIdentifier.forUid(uid), name, typeInfo);
    }

    public <T> DataStream<T> readUnionState(OperatorIdentifier identifier, String name, TypeInformation<T> typeInfo) throws IOException {
        return this.readUnionState(identifier, typeInfo, new ListStateDescriptor(name, typeInfo));
    }

    public <T> DataStream<T> readUnionState(String uid, String name, TypeInformation<T> typeInfo, TypeSerializer<T> serializer) throws IOException {
        return this.readUnionState(OperatorIdentifier.forUid(uid), name, typeInfo, serializer);
    }

    public <T> DataStream<T> readUnionState(OperatorIdentifier identifier, String name, TypeInformation<T> typeInfo, TypeSerializer<T> serializer) throws IOException {
        return this.readUnionState(identifier, typeInfo, new ListStateDescriptor(name, serializer));
    }

    private <T> DataStream<T> readUnionState(OperatorIdentifier identifier, TypeInformation<T> typeInfo, ListStateDescriptor<T> descriptor) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(identifier);
        UnionStateInputFormat<T> inputFormat = new UnionStateInputFormat<T>(operatorState, MutableConfig.of(this.env.getConfiguration()), this.stateBackend, descriptor, this.env.getConfig());
        return SourceBuilder.fromFormat(this.env, inputFormat, typeInfo);
    }

    @Deprecated
    public <K, V> DataStream<Tuple2<K, V>> readBroadcastState(String uid, String name, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo) throws IOException {
        return this.readBroadcastState(OperatorIdentifier.forUid(uid), name, keyTypeInfo, valueTypeInfo);
    }

    public <K, V> DataStream<Tuple2<K, V>> readBroadcastState(OperatorIdentifier identifier, String name, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo) throws IOException {
        return this.readBroadcastState(identifier, keyTypeInfo, valueTypeInfo, new MapStateDescriptor(name, keyTypeInfo, valueTypeInfo));
    }

    @Deprecated
    public <K, V> DataStream<Tuple2<K, V>> readBroadcastState(String uid, String name, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) throws IOException {
        return this.readBroadcastState(OperatorIdentifier.forUid(uid), name, keyTypeInfo, valueTypeInfo, keySerializer, valueSerializer);
    }

    public <K, V> DataStream<Tuple2<K, V>> readBroadcastState(OperatorIdentifier identifier, String name, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) throws IOException {
        return this.readBroadcastState(identifier, keyTypeInfo, valueTypeInfo, new MapStateDescriptor(name, keySerializer, valueSerializer));
    }

    private <K, V> DataStream<Tuple2<K, V>> readBroadcastState(OperatorIdentifier identifier, TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, MapStateDescriptor<K, V> descriptor) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(identifier);
        BroadcastStateInputFormat<K, V> inputFormat = new BroadcastStateInputFormat<K, V>(operatorState, MutableConfig.of(this.env.getConfiguration()), this.stateBackend, descriptor, this.env.getConfig());
        return SourceBuilder.fromFormat(this.env, inputFormat, new TupleTypeInfo(new TypeInformation[]{keyTypeInfo, valueTypeInfo}));
    }

    @Deprecated
    public <K, OUT> DataStream<OUT> readKeyedState(String uid, KeyedStateReaderFunction<K, OUT> function) throws IOException {
        return this.readKeyedState(OperatorIdentifier.forUid(uid), function);
    }

    public <K, OUT> DataStream<OUT> readKeyedState(OperatorIdentifier identifier, KeyedStateReaderFunction<K, OUT> function) throws IOException {
        TypeInformation outType;
        TypeInformation keyTypeInfo;
        try {
            keyTypeInfo = TypeExtractor.createTypeInfo(KeyedStateReaderFunction.class, ((Object)function).getClass(), (int)0, null, null);
        }
        catch (InvalidTypesException e) {
            throw new InvalidProgramException("The key type of the KeyedStateReaderFunction could not be automatically determined. Please use Savepoint#readKeyedState(String, KeyedStateReaderFunction, TypeInformation, TypeInformation) instead.", (Throwable)e);
        }
        try {
            outType = TypeExtractor.getUnaryOperatorReturnType(function, KeyedStateReaderFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, (TypeInformation)keyTypeInfo, (String)Utils.getCallLocationName(), (boolean)false);
        }
        catch (InvalidTypesException e) {
            throw new InvalidProgramException("The output type of the KeyedStateReaderFunction could not be automatically determined. Please use Savepoint#readKeyedState(String, KeyedStateReaderFunction, TypeInformation, TypeInformation) instead.", (Throwable)e);
        }
        return this.readKeyedState(identifier, function, keyTypeInfo, outType);
    }

    @Deprecated
    public <K, OUT> DataStream<OUT> readKeyedState(String uid, KeyedStateReaderFunction<K, OUT> function, TypeInformation<K> keyTypeInfo, TypeInformation<OUT> outTypeInfo) throws IOException {
        return this.readKeyedState(OperatorIdentifier.forUid(uid), function, keyTypeInfo, outTypeInfo);
    }

    public <K, OUT> DataStream<OUT> readKeyedState(OperatorIdentifier identifier, KeyedStateReaderFunction<K, OUT> function, TypeInformation<K> keyTypeInfo, TypeInformation<OUT> outTypeInfo) throws IOException {
        OperatorState operatorState = this.metadata.getOperatorState(identifier);
        KeyedStateInputFormat inputFormat = new KeyedStateInputFormat(operatorState, this.stateBackend, MutableConfig.of(this.env.getConfiguration()), new KeyedStateReaderOperator<K, OUT>(function, keyTypeInfo), this.env.getConfig());
        return SourceBuilder.fromFormat(this.env, inputFormat, outTypeInfo);
    }

    public <W extends Window> WindowSavepointReader<W> window(WindowAssigner<?, W> assigner) {
        Preconditions.checkNotNull(assigner, (String)"The window assigner must not be null");
        TypeSerializer windowSerializer = assigner.getWindowSerializer(this.env.getConfig());
        return this.window(windowSerializer);
    }

    public <W extends Window> WindowSavepointReader<W> window(TypeSerializer<W> windowSerializer) {
        Preconditions.checkNotNull(windowSerializer, (String)"The window serializer must not be null");
        return new WindowSavepointReader<W>(this.env, this.metadata, this.stateBackend, windowSerializer);
    }
}

