/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf.util;

import org.apache.flink.shaded.guava32.com.google.common.base.Strings;

public class PbCodegenAppender {
    private static final int DEFAULT_INDENT = 2;
    private final StringBuilder sb = new StringBuilder();
    private int indent = 0;

    public PbCodegenAppender() {
        this.indent = 0;
    }

    public PbCodegenAppender(int indent) {
        this.indent = indent;
    }

    public void begin() {
        this.indent += 2;
    }

    public void begin(String code) {
        this.sb.append(this.indent()).append(code).append("\n");
        this.begin();
    }

    public void end() {
        this.indent -= 2;
    }

    public void end(String code) {
        this.end();
        this.sb.append(this.indent()).append(code).append("\n");
    }

    public int currentIndent() {
        return this.indent;
    }

    private String indent() {
        return Strings.repeat((String)" ", (int)this.indent);
    }

    public void appendLine(String code) {
        this.sb.append(this.indent()).append(code).append(";\n");
    }

    public void appendSegment(String code) {
        this.sb.append(code).append("\n");
    }

    public String code() {
        return this.sb.toString();
    }

    public String printWithLineNumber() {
        StringBuilder newSb = new StringBuilder();
        String[] lines = this.sb.toString().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            newSb.append("Line ").append(i + 1).append(": ").append(lines[i]).append("\n");
        }
        return newSb.toString();
    }
}

