/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.protobuf;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.formats.protobuf.PbFormatConfig;
import org.apache.flink.formats.protobuf.util.PbCodegenAppender;
import org.apache.flink.formats.protobuf.util.PbCodegenVarId;

public class PbFormatContext {
    private final PbFormatConfig pbFormatConfig;
    private final List<String> splitMethodStack = new ArrayList<String>();

    public PbFormatContext(PbFormatConfig pbFormatConfig) {
        this.pbFormatConfig = pbFormatConfig;
    }

    private String createSplitMethod(String rowDataType, String rowDataVar, String messageTypeStr, String messageTypeVar, String code) {
        int uid = PbCodegenVarId.getInstance().getAndIncrement();
        String splitMethodName = "split" + uid;
        PbCodegenAppender pbCodegenAppender = new PbCodegenAppender();
        pbCodegenAppender.appendSegment(String.format("private static void %s (%s %s, %s %s) {\n %s \n}", splitMethodName, rowDataType, rowDataVar, messageTypeStr, messageTypeVar, code));
        this.splitMethodStack.add(pbCodegenAppender.code());
        return String.format("%s(%s, %s);", splitMethodName, rowDataVar, messageTypeVar);
    }

    public String splitDeserializerRowTypeMethod(String rowDataVar, String messageTypeStr, String messageTypeVar, String code) {
        return this.createSplitMethod("GenericRowData", rowDataVar, messageTypeStr, messageTypeVar, code);
    }

    public String splitSerializerRowTypeMethod(String rowDataVar, String messageTypeStr, String messageTypeVar, String code) {
        return this.createSplitMethod("RowData", rowDataVar, messageTypeStr, messageTypeVar, code);
    }

    public List<String> getSplitMethodStack() {
        return this.splitMethodStack;
    }

    public PbFormatConfig getPbFormatConfig() {
        return this.pbFormatConfig;
    }
}

