/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.type;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlRowTypeNameSpec;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;

public class ExtendedSqlRowTypeNameSpec
extends SqlTypeNameSpec {
    private final List<SqlIdentifier> fieldNames;
    private final List<SqlDataTypeSpec> fieldTypes;
    private final List<SqlCharStringLiteral> comments;
    private final boolean unparseAsStandard;

    public ExtendedSqlRowTypeNameSpec(SqlParserPos pos, List<SqlIdentifier> fieldNames, List<SqlDataTypeSpec> fieldTypes, List<SqlCharStringLiteral> comments, boolean unparseAsStandard) {
        super(new SqlIdentifier(SqlTypeName.ROW.getName(), pos), pos);
        this.fieldNames = fieldNames;
        this.fieldTypes = fieldTypes;
        this.comments = comments;
        this.unparseAsStandard = unparseAsStandard;
    }

    public List<SqlIdentifier> getFieldNames() {
        return this.fieldNames;
    }

    public List<SqlDataTypeSpec> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<SqlCharStringLiteral> getComments() {
        return this.comments;
    }

    public boolean unparseAsStandard() {
        return this.unparseAsStandard;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.print("ROW");
        if (this.fieldNames.isEmpty()) {
            if (this.unparseAsStandard) {
                writer.print("()");
            } else {
                writer.print("<>");
            }
        } else {
            SqlWriter.Frame frame = this.unparseAsStandard ? writer.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.FUN_CALL, "(", ")") : writer.startList((SqlWriter.FrameType)SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
            int i = 0;
            for (Pair p : Pair.zip(this.fieldNames, this.fieldTypes)) {
                assert (p.left != null);
                assert (p.right != null);
                writer.sep(",", false);
                ((SqlIdentifier)p.left).unparse(writer, 0, 0);
                ((SqlDataTypeSpec)p.right).unparse(writer, leftPrec, rightPrec);
                if (((SqlDataTypeSpec)p.right).getNullable() != null && !((SqlDataTypeSpec)p.right).getNullable().booleanValue()) {
                    writer.keyword("NOT NULL");
                }
                if (this.comments.get(i) != null) {
                    this.comments.get(i).unparse(writer, leftPrec, rightPrec);
                }
                ++i;
            }
            writer.endList(frame);
        }
    }

    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        int i;
        if (!(spec instanceof SqlRowTypeNameSpec)) {
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        ExtendedSqlRowTypeNameSpec that = (ExtendedSqlRowTypeNameSpec)spec;
        if (this.fieldNames.size() != that.fieldNames.size()) {
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        for (i = 0; i < this.fieldNames.size(); ++i) {
            if (this.fieldNames.get(i).equalsDeep((SqlNode)that.fieldNames.get(i), litmus)) continue;
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        if (this.fieldTypes.size() != that.fieldTypes.size()) {
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        for (i = 0; i < this.fieldTypes.size(); ++i) {
            if (this.fieldTypes.get(i).equalsDeep((SqlNode)that.fieldTypes.get(i), litmus)) continue;
            return litmus.fail("{} != {}", new Object[]{this, spec});
        }
        return litmus.succeed();
    }

    public RelDataType deriveType(SqlValidator sqlValidator) {
        RelDataTypeFactory typeFactory = sqlValidator.getTypeFactory();
        return typeFactory.createStructType(this.fieldTypes.stream().map(dt -> dt.deriveType(sqlValidator)).collect(Collectors.toList()), this.fieldNames.stream().map(SqlIdentifier::toString).collect(Collectors.toList()));
    }
}

