/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlDropCatalog
extends SqlDrop {
    private static final SqlOperator OPERATOR = new SqlSpecialOperator("DROP CATALOG", SqlKind.OTHER_DDL);
    private final SqlIdentifier catalogName;
    private final boolean ifExists;

    public SqlDropCatalog(SqlParserPos pos, SqlIdentifier catalogName, boolean ifExists) {
        super(OPERATOR, pos, false);
        this.catalogName = catalogName;
        this.ifExists = ifExists;
    }

    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of((Object)this.catalogName);
    }

    public SqlIdentifier getCatalogName() {
        return this.catalogName;
    }

    public boolean getIfExists() {
        return this.ifExists;
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("CATALOG");
        if (this.ifExists) {
            writer.keyword("IF EXISTS");
        }
        this.catalogName.unparse(writer, leftPrec, rightPrec);
    }

    public String catalogName() {
        return this.catalogName.getSimple();
    }
}

