/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.jdbc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.client.gateway.StatementResult;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.jdbc.BaseResultSet;
import org.apache.flink.table.jdbc.FlinkResultSetMetaData;
import org.apache.flink.table.jdbc.utils.CloseableResultIterator;
import org.apache.flink.table.jdbc.utils.DriverUtils;
import org.apache.flink.table.jdbc.utils.StatementResultIterator;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;

public class FlinkResultSet
extends BaseResultSet {
    private final List<DataType> dataTypeList;
    private final List<String> columnNameList;
    private final List<RowData.FieldGetter> fieldGetterList;
    private final Statement statement;
    private final CloseableResultIterator<RowData> iterator;
    private final FlinkResultSetMetaData resultSetMetaData;
    private RowData currentRow;
    private boolean wasNull;
    private volatile boolean closed;

    public FlinkResultSet(Statement statement, StatementResult result) {
        this(statement, new StatementResultIterator(result), result.getResultSchema());
    }

    public FlinkResultSet(Statement statement, CloseableResultIterator<RowData> iterator, ResolvedSchema schema) {
        this.statement = DriverUtils.checkNotNull(statement, "Statement cannot be null");
        this.iterator = DriverUtils.checkNotNull(iterator, "Statement result cannot be null");
        this.currentRow = null;
        this.wasNull = false;
        this.dataTypeList = schema.getColumnDataTypes();
        this.columnNameList = schema.getColumnNames();
        this.fieldGetterList = this.createFieldGetterList(this.dataTypeList);
        this.resultSetMetaData = new FlinkResultSetMetaData(this.columnNameList, this.dataTypeList);
    }

    private List<RowData.FieldGetter> createFieldGetterList(List<DataType> dataTypeList) {
        ArrayList<RowData.FieldGetter> fieldGetterList = new ArrayList<RowData.FieldGetter>(dataTypeList.size());
        for (int i = 0; i < dataTypeList.size(); ++i) {
            fieldGetterList.add(RowData.createFieldGetter((LogicalType)dataTypeList.get(i).getLogicalType(), (int)i));
        }
        return fieldGetterList;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.iterator.hasNext()) {
            this.currentRow = (RowData)this.iterator.next();
            this.wasNull = this.currentRow == null;
            return true;
        }
        return false;
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("This result set is already closed");
        }
    }

    private void checkValidRow() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("Not on a valid row");
        }
        if (this.currentRow.getArity() <= 0) {
            throw new SQLException("Empty row with no data");
        }
    }

    private void checkValidColumn(int columnIndex) throws SQLException {
        if (columnIndex <= 0) {
            throw new SQLException(String.format("Column index[%s] must be positive.", columnIndex));
        }
        int columnCount = this.currentRow.getArity();
        if (columnIndex > columnCount) {
            throw new SQLException(String.format("Column index %s out of bound. There are only %s columns.", columnIndex, columnCount));
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.iterator.close();
        }
        catch (Exception e) {
            throw new SQLException("Close result iterator fail", e);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        StringData stringData = this.currentRow.getString(columnIndex - 1);
        try {
            return stringData == null ? null : stringData.toString();
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return !this.currentRow.isNullAt(columnIndex - 1) && this.currentRow.getBoolean(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? (byte)0 : this.currentRow.getByte(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? (short)0 : this.currentRow.getShort(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? 0 : this.currentRow.getInt(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? 0L : this.currentRow.getLong(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? 0.0f : this.currentRow.getFloat(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? 0.0 : this.currentRow.getDouble(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale, RoundingMode.HALF_EVEN);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            return this.currentRow.getBinary(columnIndex - 1);
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)this.getObject(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)this.getObject(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)this.getObject(columnIndex);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getColumnIndex(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getColumnIndex(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getColumnIndex(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getColumnIndex(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getColumnIndex(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getColumnIndex(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getColumnIndex(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getColumnIndex(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel), scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getColumnIndex(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getColumnIndex(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getColumnIndex(columnLabel));
    }

    private int getColumnIndex(String columnLabel) throws SQLException {
        int columnIndex = this.columnNameList.indexOf(columnLabel) + 1;
        if (columnIndex <= 0) {
            throw new SQLDataException(String.format("Column[%s] is not exist", columnLabel));
        }
        return columnIndex;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        try {
            Object object = this.fieldGetterList.get(columnIndex - 1).getFieldOrNull(this.currentRow);
            DataType dataType = this.dataTypeList.get(columnIndex - 1);
            return this.convertToJavaObject(object, dataType.getLogicalType());
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    private Object convertToJavaObject(Object object, LogicalType dataType) throws SQLException {
        if (object == null) {
            return null;
        }
        switch (dataType.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case BINARY: 
            case VARBINARY: {
                return object;
            }
            case VARCHAR: 
            case CHAR: {
                return object.toString();
            }
            case DECIMAL: {
                return ((DecimalData)object).toBigDecimal();
            }
            case MAP: {
                LogicalType keyType = ((MapType)dataType).getKeyType();
                LogicalType valueType = ((MapType)dataType).getValueType();
                ArrayData.ElementGetter keyGetter = ArrayData.createElementGetter((LogicalType)keyType);
                ArrayData.ElementGetter valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
                MapData mapData = (MapData)object;
                int size = mapData.size();
                ArrayData keyArrayData = mapData.keyArray();
                ArrayData valueArrayData = mapData.valueArray();
                HashMap<Object, Object> mapResult = new HashMap<Object, Object>();
                for (int i = 0; i < size; ++i) {
                    mapResult.put(this.convertToJavaObject(keyGetter.getElementOrNull(keyArrayData, i), keyType), this.convertToJavaObject(valueGetter.getElementOrNull(valueArrayData, i), valueType));
                }
                return mapResult;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return ((TimestampData)object).toTimestamp();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                throw new SQLDataException("TIMESTAMP WITH TIME ZONE is not supported, use TIMESTAMP or TIMESTAMP_LTZ instead");
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return Time.valueOf(LocalTime.ofNanoOfDay((long)((Number)object).intValue() * 1000000L));
            }
            case DATE: {
                return Date.valueOf(LocalDate.ofEpochDay(((Number)object).intValue()));
            }
        }
        throw new SQLDataException(String.format("Not supported value type %s", dataType));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getColumnIndex(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.getColumnIndex(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkClosed();
        this.checkValidRow();
        this.checkValidColumn(columnIndex);
        DataType dataType = this.dataTypeList.get(columnIndex - 1);
        if (!(dataType.getLogicalType() instanceof DecimalType)) {
            throw new SQLException(String.format("Invalid data type, expect %s but was %s", DecimalType.class.getSimpleName(), dataType.getLogicalType().getClass().getSimpleName()));
        }
        DecimalType decimalType = (DecimalType)dataType.getLogicalType();
        try {
            return this.currentRow.isNullAt(columnIndex - 1) ? null : this.currentRow.getDecimal(columnIndex - 1, decimalType.getPrecision(), decimalType.getScale()).toBigDecimal();
        }
        catch (Exception e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getColumnIndex(columnLabel));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getArray is not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getColumnIndex(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getObject is not supported");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getObject is not supported");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getObject is not supported");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getObject is not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getObject is not supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("FlinkResultSet#getObject is not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }
}

