/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class TypeLiteralExpression
implements ResolvedExpression {
    private final DataType dataType;

    public TypeLiteralExpression(DataType dataType) {
        this.dataType = Preconditions.checkNotNull(dataType, "Data type must not be null.");
    }

    @Override
    public DataType getOutputDataType() {
        return this.dataType;
    }

    @Override
    public List<ResolvedExpression> getResolvedChildren() {
        return Collections.emptyList();
    }

    @Override
    public String asSummaryString() {
        return this.dataType.toString();
    }

    @Override
    public String asSerializableString(SqlFactory sqlFactory) {
        LogicalType logicalType = this.dataType.getLogicalType();
        return logicalType.copy(true).asSerializableString();
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public <R> R accept(ExpressionVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeLiteralExpression that = (TypeLiteralExpression)o;
        return this.dataType.equals(that.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.dataType);
    }

    public String toString() {
        return this.asSummaryString();
    }
}

