/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.util.FlinkRuntimeException;

public interface GatewayRetriever<T extends RpcGateway> {
    public CompletableFuture<T> getFuture();

    default public Optional<T> getNow() {
        CompletableFuture<T> leaderFuture = this.getFuture();
        if (leaderFuture != null) {
            if (leaderFuture.isCompletedExceptionally() || leaderFuture.isCancelled()) {
                return Optional.empty();
            }
            if (leaderFuture.isDone()) {
                try {
                    return Optional.of((RpcGateway)leaderFuture.get());
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Unexpected error while accessing the retrieved gateway.", e);
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

