/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.BlockingResultInfo;
import org.apache.flink.util.Preconditions;

abstract class AbstractBlockingResultInfo
implements BlockingResultInfo {
    private final IntermediateDataSetID resultId;
    protected final int numOfPartitions;
    protected final int numOfSubpartitions;
    protected final Map<Integer, long[]> subpartitionBytesByPartitionIndex;

    AbstractBlockingResultInfo(IntermediateDataSetID resultId, int numOfPartitions, int numOfSubpartitions, Map<Integer, long[]> subpartitionBytesByPartitionIndex) {
        this.resultId = Preconditions.checkNotNull(resultId);
        this.numOfPartitions = numOfPartitions;
        this.numOfSubpartitions = numOfSubpartitions;
        this.subpartitionBytesByPartitionIndex = new HashMap<Integer, long[]>(subpartitionBytesByPartitionIndex);
    }

    @Override
    public IntermediateDataSetID getResultId() {
        return this.resultId;
    }

    @Override
    public void recordPartitionInfo(int partitionIndex, ResultPartitionBytes partitionBytes) {
        Preconditions.checkState(partitionBytes.getSubpartitionBytes().length == this.numOfSubpartitions);
        this.subpartitionBytesByPartitionIndex.put(partitionIndex, partitionBytes.getSubpartitionBytes());
    }

    @Override
    public void resetPartitionInfo(int partitionIndex) {
        this.subpartitionBytesByPartitionIndex.remove(partitionIndex);
    }

    @VisibleForTesting
    int getNumOfRecordedPartitions() {
        return this.subpartitionBytesByPartitionIndex.size();
    }

    @Override
    public Map<Integer, long[]> getSubpartitionBytesByPartitionIndex() {
        return Collections.unmodifiableMap(this.subpartitionBytesByPartitionIndex);
    }

    @Override
    public long getNumBytesProduced(IndexRange partitionIndexRange, IndexRange subpartitionIndexRange) {
        long inputBytes = 0L;
        for (int i = partitionIndexRange.getStartIndex(); i <= partitionIndexRange.getEndIndex(); ++i) {
            Preconditions.checkState(this.subpartitionBytesByPartitionIndex.get(i) != null, "Partition index %s is not ready.", i);
            Preconditions.checkState(subpartitionIndexRange.getEndIndex() < this.subpartitionBytesByPartitionIndex.get(i).length, "Subpartition end index %s is out of range of partition %s.", subpartitionIndexRange.getEndIndex(), i);
            for (int j = subpartitionIndexRange.getStartIndex(); j <= subpartitionIndexRange.getEndIndex(); ++j) {
                inputBytes += this.subpartitionBytesByPartitionIndex.get(i)[j];
            }
        }
        return inputBytes;
    }
}

