/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.util.stats;

import java.util.Objects;
import org.apache.flink.runtime.util.stats.StatsSummary;
import org.apache.flink.runtime.util.stats.StatsSummarySnapshot;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;

public final class StatsSummaryDto {
    public static final String FIELD_NAME_MINIMUM = "min";
    public static final String FIELD_NAME_MAXIMUM = "max";
    public static final String FIELD_NAME_AVERAGE = "avg";
    public static final String FIELD_NAME_P50 = "p50";
    public static final String FIELD_NAME_P90 = "p90";
    public static final String FIELD_NAME_P95 = "p95";
    public static final String FIELD_NAME_P99 = "p99";
    public static final String FIELD_NAME_P999 = "p999";
    @JsonProperty(value="min")
    private final long minimum;
    @JsonProperty(value="max")
    private final long maximum;
    @JsonProperty(value="avg")
    private final long average;
    @JsonProperty(value="p50")
    private final double p50;
    @JsonProperty(value="p90")
    private final double p90;
    @JsonProperty(value="p95")
    private final double p95;
    @JsonProperty(value="p99")
    private final double p99;
    @JsonProperty(value="p999")
    private final double p999;

    public static StatsSummaryDto valueOf(StatsSummary s) {
        return StatsSummaryDto.valueOf(s.createSnapshot());
    }

    public static StatsSummaryDto valueOf(StatsSummarySnapshot snapshot) {
        return new StatsSummaryDto(snapshot.getMinimum(), snapshot.getMaximum(), snapshot.getAverage(), snapshot.getQuantile(0.5), snapshot.getQuantile(0.9), snapshot.getQuantile(0.95), snapshot.getQuantile(0.99), snapshot.getQuantile(0.999));
    }

    @JsonCreator
    public StatsSummaryDto(@JsonProperty(value="min") long minimum, @JsonProperty(value="max") long maximum, @JsonProperty(value="avg") long average, @JsonProperty(value="p50") double p50, @JsonProperty(value="p90") double p90, @JsonProperty(value="p95") double p95, @JsonProperty(value="p99") double p99, @JsonProperty(value="p999") double p999) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.average = average;
        this.p50 = p50;
        this.p90 = p90;
        this.p95 = p95;
        this.p99 = p99;
        this.p999 = p999;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public long getMaximum() {
        return this.maximum;
    }

    public long getAverage() {
        return this.average;
    }

    public double getP50() {
        return this.p50;
    }

    public double getP90() {
        return this.p90;
    }

    public double getP95() {
        return this.p95;
    }

    public double getP99() {
        return this.p99;
    }

    public double getP999() {
        return this.p999;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatsSummaryDto that = (StatsSummaryDto)o;
        return this.minimum == that.minimum && this.maximum == that.maximum && this.average == that.average && Double.compare(this.p50, that.p50) == 0 && Double.compare(this.p90, that.p90) == 0 && Double.compare(this.p95, that.p95) == 0 && Double.compare(this.p99, that.p99) == 0 && Double.compare(this.p999, that.p999) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum, this.average, this.p50, this.p90, this.p95, this.p99, this.p999);
    }
}

