/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.handler.util;

import java.nio.charset.Charset;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigConstants;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponse;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpVersion;
import org.apache.flink.util.Preconditions;

public class HandlerRedirectUtils {
    public static final Charset ENCODING = ConfigConstants.DEFAULT_CHARSET;

    public static HttpResponse getRedirectResponse(String redirectAddress, String path, HttpResponseStatus code) {
        Preconditions.checkNotNull(redirectAddress, "Redirect address");
        Preconditions.checkNotNull(path, "Path");
        String newLocation = String.format("%s%s", redirectAddress, path);
        DefaultFullHttpResponse redirectResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, code);
        redirectResponse.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)newLocation);
        redirectResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        return redirectResponse;
    }

    public static HttpResponse getResponse(HttpResponseStatus status, @Nullable String message) {
        ByteBuf messageByteBuf = message == null ? Unpooled.buffer(0) : Unpooled.wrappedBuffer(message.getBytes(ENCODING));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, messageByteBuf);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("text/plain; charset=" + ENCODING.name()));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }
}

