/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import javax.annotation.Nullable;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.state.memory.ByteStreamStateHandle;

public class FullyFinishedOperatorState
extends OperatorState {
    private static final long serialVersionUID = 1L;

    public FullyFinishedOperatorState(@Nullable String operatorName, @Nullable String operatorUid, OperatorID operatorID, int parallelism, int maxParallelism) {
        super(operatorName, operatorUid, operatorID, parallelism, maxParallelism);
    }

    @Override
    public boolean isFullyFinished() {
        return true;
    }

    @Override
    public void putState(int subtaskIndex, OperatorSubtaskState subtaskState) {
        throw new UnsupportedOperationException("Could not put state to a fully finished operator state.");
    }

    @Override
    public void setCoordinatorState(@Nullable ByteStreamStateHandle coordinatorState) {
        throw new UnsupportedOperationException("Could not set coordinator state to a fully finished operator state.");
    }

    @Override
    public OperatorState copyAndDiscardInFlightData() {
        return new FullyFinishedOperatorState(this.getOperatorName().orElse(null), this.getOperatorUid().orElse(null), this.getOperatorID(), this.getParallelism(), this.getMaxParallelism());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FullyFinishedOperatorState) {
            return super.equals(obj);
        }
        return false;
    }

    @Override
    public String toString() {
        return "FullyFinishedOperatorState(name: " + String.valueOf(this.getOperatorName()) + "uid: " + String.valueOf(this.getOperatorUid()) + "operatorID: " + String.valueOf(this.getOperatorID()) + ", parallelism: " + this.getParallelism() + ", maxParallelism: " + this.getMaxParallelism() + ")";
    }
}

